package com.pcloud.book.clock.dto;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.ClassifyDTO;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:52
 * @Version 1.0
 */
public class BookClockKeywordDTO extends BaseDto {

    private static final long serialVersionUID = -6521664243643931466L;

    @ApiModelProperty("bookClockKeywordId")
    private Long bookClockKeywordId;

    @ApiModelProperty("作品/应用ID")
    private Long bookClockInfoId;

    @ApiModelProperty("操作")
    private String operation;

    @ApiModelProperty("关键词")
    private String keyword;

    @ApiModelProperty("关键词引导语")
    private String guide;

    @ApiModelProperty("渠道ID")
    private Long channelId;

    @ApiModelProperty("排序值")
    private Long sequenceNum;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("社群书集合")
    private List<BookGroupDTO> bookGroupDTOList;

    @ApiModelProperty("分类集合")
    private List<ClassifyDTO> classifyDTOList;

    public Long getBookClockKeywordId() {
        return bookClockKeywordId;
    }

    public void setBookClockKeywordId(Long bookClockKeywordId) {
        this.bookClockKeywordId = bookClockKeywordId;
    }

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public String getOperation() {
        return operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getGuide() {
        return guide;
    }

    public void setGuide(String guide) {
        this.guide = guide;
    }

    public Long getSequenceNum() {
        return sequenceNum;
    }

    public void setSequenceNum(Long sequenceNum) {
        this.sequenceNum = sequenceNum;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<BookGroupDTO> getBookGroupDTOList() {
        return bookGroupDTOList;
    }

    public void setBookGroupDTOList(List<BookGroupDTO> bookGroupDTOList) {
        this.bookGroupDTOList = bookGroupDTOList;
    }

    public List<ClassifyDTO> getClassifyDTOList() {
        return classifyDTOList;
    }

    public void setClassifyDTOList(List<ClassifyDTO> classifyDTOList) {
        this.classifyDTOList = classifyDTOList;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    @Override
    public String toString() {
        return JSONObject.toJSONString(this);
    }
}
