package com.pcloud.book.consumer.convert;


import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.convert.file.entity.FileUploadInfo;
import com.pcloud.convert.file.service.ConvertFileService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @描述：
 * @作者：zhuyajie
 * @创建时间：19:44 2019/7/31
 * @版本：1.0
 */
@Repository("convertConsr")
public class ConvertConsr {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertConsr.class);

    @Autowired
    private ConvertFileService convertFileService;

    /**
     * 获取转码文件
     * @param fileId
     * @return
     */
    @ParamLog("获取转码文件")
    public FileUploadInfo getByFileId(String fileId) {
        FileUploadInfo fileUploadInfo = null;
        try {
            fileUploadInfo = ResponseHandleUtil.parseResponse(convertFileService.getByFileId(fileId), FileUploadInfo.class);
        } catch (Exception e) {
            LOGGER.error("调用convertFileService.getByFileId失败" + e.getMessage(), e);
        }
        return fileUploadInfo;
    }

}
