package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupAgentRecordDao;
import com.pcloud.book.group.entity.BookGroupAgentRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/11/8 11:41
 **/
@Component("bookGroupAgentRecordDao")
public class BookGroupAgentRecordDaoImpl  extends BaseDaoImpl<BookGroupAgentRecord> implements BookGroupAgentRecordDao {
    @Override
    public BookGroupAgentRecord getByAltIdAndBookGroupId(String altId, Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("altId", altId);
        map.put("bookGroupId",bookGroupId);
        return super.getSqlSession().selectOne(getStatement("getByAltIdAndBookGroupId"), map);
    }

    @Override
    public List<BookGroupAgentRecord> getAltIdByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds",bookGroupIds);
        return super.getSqlSession().selectList(getStatement("getByAltIdAndBookGroupId"), map);
    }
}
