package com.pcloud.book.group.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.GroupQrcodeBiz;
import com.pcloud.book.group.biz.WeixinQrcodeBiz;
import com.pcloud.book.group.dto.BookWxQrcodeDTO;
import com.pcloud.book.group.facade.GroupQrcodeFacade;
import com.pcloud.book.group.service.WeixinQrcodeService;
import com.pcloud.book.group.vo.ClassifyQrcodeVO;
import com.pcloud.book.group.vo.GroupQrcodeBaseInfoVO;
import com.pcloud.book.group.vo.GroupQrcodeBookVO;
import com.pcloud.book.group.vo.ListQrcodeByClassifyParamVO;
import com.pcloud.book.group.vo.UpdateGroupQrcodeRequestVO;
import com.pcloud.book.group.vo.WechatGroupNameVO;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

import io.swagger.annotations.ApiOperation;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/19 15:36
 */
@RestController("groupQrcodeFacade")
@RequestMapping("groupQrcode")
public class GroupQrcodeFacadeImpl implements GroupQrcodeFacade {

    @Autowired
    private GroupQrcodeBiz groupQrcodeBiz;
    @Autowired
    private WeixinQrcodeBiz weixinQrcodeBiz;

    @GetMapping("listAllGroupQrcode")
    public ResponseDto<PageBeanNew> listAllGroupQrcode(@RequestHeader("token") String token,
                                                         @RequestParam(value = "wxGroupName", required = false) String wxGroupName,
                                                         @RequestParam("currentPage") Integer currentPage,
                                                         @RequestParam("numPerPage") Integer numPerPage) {
        return new ResponseDto<>(groupQrcodeBiz.listAllGroupQrcode(wxGroupName, currentPage, numPerPage));
    }

    @PostMapping("updateGroupQrcode")
    public ResponseDto<Void> updateGroupQrcode(@RequestHeader("token") String token, @RequestBody UpdateGroupQrcodeRequestVO vo) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(partyId);
        groupQrcodeBiz.updateGroupQrcode(vo);
        return new ResponseDto<>();
    }

    @GetMapping("getChangeGroupQrCode")
    public ResponseDto<String> getChangeGroupQrCode(@CookieValue("userInfo") String userInfo, @RequestParam("classifyId") Long classifyId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        String qrCodeUrl = groupQrcodeBiz.getChangeGroupQrCode(classifyId);
        return new ResponseDto<>(qrCodeUrl);
    }

    @Override
    @PostMapping("listQrcodeByClassify")
    public ResponseDto<PageBeanNew> listQrcodeByClassify(@RequestHeader("token") String token, @RequestBody ListQrcodeByClassifyParamVO listQrcodeByClassifyParamVO) {
        PageBeanNew<ClassifyQrcodeVO> listAllClassify = groupQrcodeBiz.listQrcodeByClassify(listQrcodeByClassifyParamVO);
        return new ResponseDto<>(listAllClassify);
    }

    @Override
    @RequestMapping(value = "getQrcodeByClassify", method = RequestMethod.GET)
    public ResponseDto<?> getQrcodeByClassify(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId,
                                              @RequestParam("classifyId") Long classifyId) throws PermissionException {
        List<ClassifyQrcodeVO> qrcodeByClassify = groupQrcodeBiz.getQrcodeByClassify(bookGroupId, classifyId);
        return new ResponseDto<>(qrcodeByClassify);
    }

    @Override
    @PostMapping("modifyWechatGroupName")
    @ApiOperation("修改微信群名称")
    public ResponseDto<?> modifyWechatGroupName(@RequestHeader("token") String token, @RequestBody WechatGroupNameVO wechatGroupNameVO)
            throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        groupQrcodeBiz.modifyWechatGroupName(wechatGroupNameVO.getWechatGroupName(), wechatGroupNameVO.getId(), partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getBaseById")
    public ResponseDto<GroupQrcodeBaseInfoVO> getBaseById(@RequestHeader("token")String token, @RequestParam("groupQrcodeId") Long groupQrcodeId) throws BizException, JsonParseException, PermissionException {
        GroupQrcodeBaseInfoVO groupQrcodeBaseInfoVO = groupQrcodeBiz.getBaseById(groupQrcodeId);
        return new ResponseDto<>(groupQrcodeBaseInfoVO == null ? new GroupQrcodeBaseInfoVO() : groupQrcodeBaseInfoVO);
    }

    @Override
    @RequestMapping(value = "listQrcodeByAdviser", method = RequestMethod.GET)
    public ResponseDto<PageBeanNew> listQrcodeByAdviser(
            @RequestHeader("token") String token, @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage, @RequestParam(value = "name", required = false) String name) throws PermissionException {
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "缺少分页参数");
        }
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        PageBeanNew<GroupQrcodeBookVO> pageBeanNew = groupQrcodeBiz.listQrcodeByAdviser(currentPage, numPerPage, name, adviserId);
        return new ResponseDto<>(pageBeanNew);
    }


    @GetMapping("addUser")
    ResponseDto<?> addUser(@RequestParam("weixinGroupId") String weixinGroupId, @RequestParam("userNumber") Integer userNumber)
            throws BizException{
        final Map<String, BookWxQrcodeDTO> groupVersion = weixinQrcodeBiz.getGroupVersion(Collections.singletonList(weixinGroupId));
        groupQrcodeBiz.addOneUser(weixinGroupId, userNumber, null, null, Optional.ofNullable(groupVersion.get(weixinGroupId)).orElse(new BookWxQrcodeDTO()).getWechatGroupIp());
        return new ResponseDto<>();
    }

    @GetMapping("updateUserNumber")
    ResponseDto<?> updateUserNumber(@RequestParam("weixinGroupId") String weixinGroupId, @RequestParam("wxUserId") String wxUserId)
            throws BizException {
        groupQrcodeBiz.updateUserNumber(weixinGroupId, wxUserId);
        return new ResponseDto<>();
    }

    @RequestMapping(value = "listQrcodeByPcloud", method = RequestMethod.GET)
    @Override
    public ResponseDto<PageBeanNew> listQrcodeByPcloud(
            @RequestHeader("token") String token, @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage,@RequestParam(value = "name", required = false) String name) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<GroupQrcodeBookVO> pageBeanNew = groupQrcodeBiz.listQrcodeByPcloud(currentPage, numPerPage, name);
        return new ResponseDto<>(pageBeanNew);
    }

    @ApiOperation("根据类型获取当前群总人数")
    @GetMapping("getUserCountByJoinGroupType")
    @Override
    public ResponseDto<?> getUserCountByJoinGroupType(
            @RequestHeader("token") String token,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType
    ) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)) {
            throw new PermissionException(PermissionException.PERMISSION_NOT_FOUND);
        }
        return new ResponseDto<>(groupQrcodeBiz.getUserCountByJoinGroupType(joinGroupType));
    }
}
