package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @描述：社群书分析-平台端
 * @作者：zhuyajie
 * @创建时间：9:07 2019/9/29
 * @版本：1.0
 */
public class BookGroupAnalysisVO extends BaseDto {
    /**
     * 社群码ID
     */
    private Long bookGroupId;
    /**
     * 社群码
     */
    private String groupQrcodeUrl;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    /**
     * 书籍标识
     */
    private Long bookId;

    /**
     * 书籍ISBN码
     */
    private String isbn;

    /**
     * 书籍名称
     */
    private String bookName;

    /**
     * 一级分类id
     */
    private Long templetId;
    /**
     * 一级分类名称
     */
    private String templetName;
    /**
     * 二级分类id
     */
    private Long secondTempletId;
    /**
     * 二级分类名称
     */
    private String secondTempletName;
    /**
     * 编辑标识
     */
    private Long adviserId;

    /**
     * 编辑名称
     */
    private String adviserName;
    /**
     * 出版ID
     */
    private Long agentId;

    /**
     * 出版社名称
     */
    private String agentName;
    /**
     * 渠道标识
     */
    private Long channelId;

    /**
     * 渠道名称
     */
    private String channelName;
    /**
     * 书刊是否有基金支持
     */
    private Boolean isFundSupport;
    /**
     * 是否版权保护
     */
    private Boolean isCopyright;

    //社群码 微信群数据
    /**
     * 扫码次数
     */
    private Integer scanCount;
    /**
     * 扫码人数
     */
    private Integer scanUserCount;
    /**
     * 进群方式：1群二维码，2客服机器人
     */
    private Integer joinGroupType;
    /**
     * 群分类数量
     */
    private Integer classifyCount;
    /**
     * 群总人数
     */
    private Integer userNumber;

    /**
     * 累计进群人数
     */
    private Integer joinUserCount;

    /**
     * 群数量
     */
    private Integer groupCount;
    /**
     * 好友数量
     */
    private Integer friendsCount;

    //配置资源数据
    /**
     * 配置资源个数
     */
    private Integer resourceCount;
    /**
     * 浏览量
     */
    private Integer browseCount;

    /**
     * 读者量
     */
    private Integer browserCount;

    //资源销售数据

    /**
     * 销售额
     */
    private BigDecimal saleAmount;
    /**
     *支付率
     */
    private BigDecimal payRate;
    /**
     *客单价
     */
    private BigDecimal avgSaleAmount;


    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getTempletId() {
        return templetId;
    }

    public void setTempletId(Long templetId) {
        this.templetId = templetId;
    }

    public String getTempletName() {
        return templetName;
    }

    public void setTempletName(String templetName) {
        this.templetName = templetName;
    }

    public Long getSecondTempletId() {
        return secondTempletId;
    }

    public void setSecondTempletId(Long secondTempletId) {
        this.secondTempletId = secondTempletId;
    }

    public String getSecondTempletName() {
        return secondTempletName;
    }

    public void setSecondTempletName(String secondTempletName) {
        this.secondTempletName = secondTempletName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public String getAdviserName() {
        return adviserName;
    }

    public void setAdviserName(String adviserName) {
        this.adviserName = adviserName;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public Boolean getIsFundSupport() {
        return isFundSupport;
    }

    public void setIsFundSupport(Boolean isFundSupport) {
        this.isFundSupport = isFundSupport;
    }

    public Integer getScanCount() {
        return scanCount;
    }

    public void setScanCount(Integer scanCount) {
        this.scanCount = scanCount;
    }

    public Integer getScanUserCount() {
        return scanUserCount;
    }

    public void setScanUserCount(Integer scanUserCount) {
        this.scanUserCount = scanUserCount;
    }

    public Integer getJoinGroupType() {
        return joinGroupType;
    }

    public void setJoinGroupType(Integer joinGroupType) {
        this.joinGroupType = joinGroupType;
    }

    public Integer getClassifyCount() {
        return classifyCount;
    }

    public void setClassifyCount(Integer classifyCount) {
        this.classifyCount = classifyCount;
    }

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public Integer getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Integer groupCount) {
        this.groupCount = groupCount;
    }

    public Integer getFriendsCount() {
        return friendsCount;
    }

    public void setFriendsCount(Integer friendsCount) {
        this.friendsCount = friendsCount;
    }

    public Integer getResourceCount() {
        return resourceCount;
    }

    public void setResourceCount(Integer resourceCount) {
        this.resourceCount = resourceCount;
    }

    public Integer getBrowseCount() {
        return browseCount;
    }

    public void setBrowseCount(Integer browseCount) {
        this.browseCount = browseCount;
    }

    public Integer getBrowserCount() {
        return browserCount;
    }

    public void setBrowserCount(Integer browserCount) {
        this.browserCount = browserCount;
    }

    public BigDecimal getSaleAmount() {
        return saleAmount;
    }

    public void setSaleAmount(BigDecimal saleAmount) {
        this.saleAmount = saleAmount;
    }

    public BigDecimal getPayRate() {
        return payRate;
    }

    public void setPayRate(BigDecimal payRate) {
        this.payRate = payRate;
    }

    public BigDecimal getAvgSaleAmount() {
        return avgSaleAmount;
    }

    public void setAvgSaleAmount(BigDecimal avgSaleAmount) {
        this.avgSaleAmount = avgSaleAmount;
    }

    public Boolean getIsCopyright() {
        return isCopyright;
    }

    public void setIsCopyright(Boolean isCopyright) {
        this.isCopyright = isCopyright;
    }

    public Integer getJoinUserCount() {
        return joinUserCount;
    }

    public void setJoinUserCount(Integer joinUserCount) {
        this.joinUserCount = joinUserCount;
    }
}
