package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/29 17:07
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GroupQrcode4ClassifyVO implements Serializable {

    @ApiModelProperty("分类标识")
    private Long classifyId;

    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

    @ApiModelProperty("群名称")
    private String groupName;

    @ApiModelProperty("用户数")
    private Integer userNumber;

    @ApiModelProperty("群二维码标识")
    private Long groupQrcodeId;

    @ApiModelProperty("备用二维码")
    private String spareQr;

    @ApiModelProperty("分类名称")
    private String classify;

    @ApiModelProperty("微信群名称")
    private String weixinGroupId;

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public Long getGroupQrcodeId() {
        return groupQrcodeId;
    }

    public void setGroupQrcodeId(Long groupQrcodeId) {
        this.groupQrcodeId = groupQrcodeId;
    }

    public Long getClassifyId() {
        return classifyId;
    }

    public void setClassifyId(Long classifyId) {
        this.classifyId = classifyId;
    }

    public String getQrcodeUrl() {
        return qrcodeUrl;
    }

    public void setQrcodeUrl(String qrcodeUrl) {
        this.qrcodeUrl = qrcodeUrl;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Integer getUserNumber() {
        return userNumber;
    }

    public void setUserNumber(Integer userNumber) {
        this.userNumber = userNumber;
    }

    public String getSpareQr() {
        return spareQr;
    }

    public void setSpareQr(String spareQr) {
        this.spareQr = spareQr;
    }

    public String getWeixinGroupId() {
        return weixinGroupId;
    }

    public void setWeixinGroupId(String weixinGroupId) {
        this.weixinGroupId = weixinGroupId;
    }

    @Override
    public String toString() {
        return "GroupQrcode4ClassifyVO{" +
                "classifyId=" + classifyId +
                ", qrcodeUrl='" + qrcodeUrl + '\'' +
                ", groupName='" + groupName + '\'' +
                ", userNumber=" + userNumber +
                ", groupQrcodeId=" + groupQrcodeId +
                ", spareQr='" + spareQr + '\'' +
                ", classify='" + classify + '\'' +
                ", weixinGroupId='" + weixinGroupId + '\'' +
                '}';
    }
}
