package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.SelfPushUserDao;
import com.pcloud.book.push.entity.SelfPushUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @描述：
 * @作者：zhuyajie
 * @创建时间：19:01 2019/11/26
 * @版本：1.0
 */
@Component("selfPushUserDao")
public class SelfPushUserDaoImpl extends BaseDaoImpl<SelfPushUser>implements SelfPushUserDao {

    @Override
    public Integer getCountByPushId(Long pushId) {
        return getSessionTemplate().selectOne(getStatement("getCountByPushId"), pushId);
    }

    @Override
    public List<String> getUserIdListByPushId(Long pushId) {
        return getSessionTemplate().selectList(getStatement("getUserIdListByPushId"), pushId);
    }
}
