package com.pcloud.book.weixinclock.vo.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.weixinclock.entity.WeixinClockCoupon;
import com.pcloud.common.utils.bean.BeanUtils;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;

/**
 * @Describe: 获取群打卡奖励优惠券返回类
 * @Author: zhangdongwei
 * @Date: Create on 20:33 2019/11/18 0018
 */
@Data
public class GetClockCouponResponseVO {
    /**
     * 优惠券平台（淘宝、京东、当当）
     */
    private Integer couponPlatform;
    /**
     * 商品名称
     */
    private String title;
    /**
     * 商品图片
     */
    private String pictUrl;
    /**
     * 商品原始价格
     */
    private BigDecimal proOriginPrice;
    /**
     * 优惠券价格
     */
    private BigDecimal couponPrice;
    /**
     * 劵后价格
     */
    private BigDecimal afterCouponPrice;
    /**
     * 优惠券点击链接
     */
    private String couponClickUrl;
    /**
     * 领取优惠券天数
     */
    private Integer dayNum;

    /**
     * 领取时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date getTime;

    /**
     * 是否有优惠券
     */
    private Integer hasCoupon;

    /**
     * 是否获得优惠券
     */
    private Integer hasGot;

    public static GetClockCouponResponseVO valueFromEntity(WeixinClockCoupon weixinClockCoupon){
        GetClockCouponResponseVO vo = BeanUtils.copy(weixinClockCoupon, GetClockCouponResponseVO.class);
        return vo;
    }
}
