package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletRecordStatisBiz;
import com.pcloud.book.applet.biz.AppletRecordStatisReportBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;

/**
 * 小睿小程序点击量统计(AppletRecordStatis)表控制层
 *
 * @author makejava
 * @since 2020-12-10 17:58:06
 */
@RestController("appletRecordStatisFacade")
@RequestMapping("appletRecordStatis")
public class AppletRecordStatisFacade {
    
    @Autowired
    private AppletRecordStatisBiz appletRecordStatisBiz;
    @Autowired
    private AppletRecordStatisReportBiz appletRecordStatisReportBiz;


    @ApiOperation("获取本周读书趋势")
    @GetMapping("getReadBookWeekStatis")
    public ResponseDto<?> getReadBookWeekStatis(@CookieValue("userInfo")String userInfo, @RequestParam("mondayDate")String mondayDate)throws BizException,PermissionException{
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordStatisBiz.getReadBookWeekStatis(wechatUserId, mondayDate));
    }

    @ApiOperation("获取本周资源使用频率分布")
    @GetMapping("getBookSourceWeekStatis")
    public ResponseDto<?> getBookSourceWeekStatis(@CookieValue("userInfo")String userInfo, @RequestParam("mondayDate")String mondayDate)throws BizException,PermissionException{
        Long wechatUserId=Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordStatisBiz.getBookSourceWeekStatis(wechatUserId,mondayDate));
    }

    @ApiOperation("获取本周推荐资讯学习频率分布")
    @GetMapping("getBookNewsWeekStatis")
    public ResponseDto<?> getBookNewsWeekStatis(@CookieValue("userInfo")String userInfo, @RequestParam("mondayDate")String mondayDate)throws BizException,PermissionException{
        Long wechatUserId=Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordStatisBiz.getBookNewsWeekStatis(wechatUserId, mondayDate));
    }

    @ApiOperation("本周综合评分")
    @GetMapping("getReadReport4Week")
    public ResponseDto<?> getReadReport4Week(@CookieValue("userInfo")String userInfo, @RequestParam("mondayDate")String mondayDate)throws BizException,PermissionException{
        Long wechatUserId=Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordStatisReportBiz.getReadReport4Week(wechatUserId, mondayDate));
    }

    @ApiOperation("历史综合评分")
    @GetMapping("getReadReportList")
    public ResponseDto<?> getReadReportList(
            @CookieValue("userInfo")String userInfo,
            @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
            @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)throws BizException,PermissionException{
        Long wechatUserId=Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordStatisReportBiz.getReadReportList(wechatUserId, currentPage, numPerPage));
    }

    @ApiOperation("分享阅读报告")
    @GetMapping("shareReadReport")
    public ResponseDto<?> shareReadReport(@CookieValue("userInfo")String userInfo, @RequestParam("mondayDate")String mondayDate)throws BizException,PermissionException{
        Long wechatUserId=Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordStatisReportBiz.shareReadReport(wechatUserId, mondayDate));
    }

}
