package com.pcloud.book.cultivate.facade;

import com.pcloud.book.cultivate.biz.CultivateRaysBiz;
import com.pcloud.book.cultivate.constant.CultivateRaysConstants;
import com.pcloud.book.cultivate.dto.CultivateRaysConversionDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cache.redis.JedisClusterUtils;
import com.pcloud.common.utils.cookie.Cookie;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(description = "宠物小睿养成")
@RestController
@RequestMapping("cultivateRays")
public class CultivateRaysFacade {

    @Autowired
    private CultivateRaysBiz cultivateRaysBiz;


    @ApiOperation("新增养成")
    @PostMapping("/createCultivate")
    public ResponseDto<?> createCultivate(
            @CookieValue(value = "userInfo") String  userInfo
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(cultivateRaysBiz.createCultivate(wechatUserId, officialAccountsId));
    }

    @ApiOperation("获取养成")
    @GetMapping("/getCultivate")
    public ResponseDto<?> getCultivate(
        @CookieValue(value = "userInfo") String  userInfo
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        return new ResponseDto<>(cultivateRaysBiz.getCultivate(wechatUserId, officialAccountsId));
    }


    @ApiOperation("书币兑换")
    @PostMapping("/rmallMoneyConversion")
    public ResponseDto<?> rmallMoneyConversion(
        @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody CultivateRaysConversionDTO cultivateRaysConversionDTO
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        cultivateRaysConversionDTO.setWechatUserId(wechatUserId);
        cultivateRaysBiz.rmallMoneyConversion(cultivateRaysConversionDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("投喂兑换时间")
    @PostMapping("/gainsConversion")
    public ResponseDto<?> gainsConversion(
            @CookieValue(value = "userInfo") String  userInfo,
            @RequestBody CultivateRaysConversionDTO cultivateRaysConversionDTO
    ) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        cultivateRaysConversionDTO.setWechatUserId(wechatUserId);
        cultivateRaysBiz.gainsConversion(cultivateRaysConversionDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("加指引记录")
    @GetMapping("addGuide")
    public ResponseDto<?> addGuide(@CookieValue(value = "userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        JedisClusterUtils.hset2Json(CultivateRaysConstants.GUIDE_REDIS, wechatUserId.toString(), 1);
        return new ResponseDto<>();
    }

    @ApiOperation("指引记录")
    @GetMapping("getGuide")
    public ResponseDto<?> getGuide(@CookieValue(value = "userInfo") String userInfo) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        String record = JedisClusterUtils.hget(CultivateRaysConstants.GUIDE_REDIS, wechatUserId.toString());
        return new ResponseDto<>(StringUtil.isEmpty(record) ? false : true);
    }

}
