package com.pcloud.book.test;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.pcloud.book.BookApplication;
import com.pcloud.book.book.dao.BookDao;
import com.pcloud.book.book.dto.BookDto;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes = {BookApplication.class, BookDaoTest.class})
public class BookDaoTest {

    @Autowired
    private BookDao bookDao;

    @Test
    public void testGetListPage() {

        String bookName = "时间 朋友";

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookName", bookName);

        String[] bookNameList = bookName.trim().split("\\s+");
        paramMap.put("bookNameList", Lists.newArrayList(bookNameList));
        paramMap.put("currentPage", 0);
        paramMap.put("numPerPage", 10);
        int count = bookDao.getBookCount4Platform(paramMap);
        List<BookDto> list = bookDao.getListPage4Platform(paramMap);

        log.info("count===>{}", count);
        log.info("list===>{}", JSON.toJSONString(list));
    }


}
