package com.pcloud.book.adnews.biz;

import com.pcloud.book.adnews.entity.AdNews;
import com.pcloud.book.adnews.entity.AdNewsSet;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface AdNewsBiz {
    /**
     * 新增早晚报设置
     */
    Long createAdNewsSet(AdNewsSet adNewsSet);

    /**
     * 修改早晚报设置
     */
    void updateAdNewsSet(AdNewsSet adNewsSet);

    /**
     * 发送编辑端早晚报
     */
    void sendAdNews(Long adNewsSetId);

    /**
     * 根据创建人获取早晚报设置
     */
    AdNewsSet getAdNewsSet(Long partyId);

    /**
     * 编辑添加选择的早晚报素材
     */
    void createAdNewsChooseBatch(List<Long> adNewsIds, Long partyId);

    /**
     * 编辑移除选择的早晚报素材
     */
    void deleteAdNewsChoose(Long adNewsId, Long partyId);

    /**
     * 获取素材库列表
     */
    PageBeanNew<AdNews> getAdNewsList(String title, Long partyId, Integer currentPage, Integer numPerPage);

    /**
     * 获取编辑已选取的素材库列表
     */
    PageBeanNew<AdNews> getAdNewsChooseList(Long partyId, String title, Boolean hasUsed, Integer currentPage, Integer numPerPage);
}
