package com.pcloud.book.adnews.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 16:13
 **/
@ApiModel("编辑新闻发送记录")
public class AdNewsSet extends BaseEntity {

    private static final long serialVersionUID = -1115799214395961840L;

    @ApiModelProperty("早报时间")
    private String morningTime;

    @ApiModelProperty("晚报时间")
    private String eveningTime;

    @ApiModelProperty("是否开启早报")
    private Boolean hasMorningOpen;

    @ApiModelProperty("是否开启晚报")
    private Boolean hasEveningOpen;

    @ApiModelProperty("发送次数")
    private Integer sendCount;

    @ApiModelProperty("开场语")
    private String startContent;

    @ApiModelProperty("结束语")
    private String endContent;

    @ApiModelProperty("是否开启开场语")
    private Boolean hasStartContent;

    @ApiModelProperty("是否开启结束语")
    private Boolean hasEndContent;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @ApiModelProperty("分类关联集合")
    private List<AdNewsGroup> adNewsGroups;

    @ApiModelProperty("分类id集合")
    private List<Long> classifyIds;

    public String getMorningTime() {
        return morningTime;
    }

    public void setMorningTime(String morningTime) {
        this.morningTime = morningTime;
    }

    public String getEveningTime() {
        return eveningTime;
    }

    public void setEveningTime(String eveningTime) {
        this.eveningTime = eveningTime;
    }

    public Boolean getHasMorningOpen() {
        return hasMorningOpen;
    }

    public void setHasMorningOpen(Boolean hasMorningOpen) {
        this.hasMorningOpen = hasMorningOpen;
    }

    public Boolean getHasEveningOpen() {
        return hasEveningOpen;
    }

    public void setHasEveningOpen(Boolean hasEveningOpen) {
        this.hasEveningOpen = hasEveningOpen;
    }

    public Integer getSendCount() {
        return sendCount;
    }

    public void setSendCount(Integer sendCount) {
        this.sendCount = sendCount;
    }

    public String getStartContent() {
        return startContent;
    }

    public void setStartContent(String startContent) {
        this.startContent = startContent;
    }

    public String getEndContent() {
        return endContent;
    }

    public void setEndContent(String endContent) {
        this.endContent = endContent;
    }

    public Boolean getHasStartContent() {
        return hasStartContent;
    }

    public void setHasStartContent(Boolean hasStartContent) {
        this.hasStartContent = hasStartContent;
    }

    public Boolean getHasEndContent() {
        return hasEndContent;
    }

    public void setHasEndContent(Boolean hasEndContent) {
        this.hasEndContent = hasEndContent;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public List<AdNewsGroup> getAdNewsGroups() {
        return adNewsGroups;
    }

    public void setAdNewsGroups(List<AdNewsGroup> adNewsGroups) {
        this.adNewsGroups = adNewsGroups;
    }

    public List<Long> getClassifyIds() {
        return classifyIds;
    }

    public void setClassifyIds(List<Long> classifyIds) {
        this.classifyIds = classifyIds;
    }

    @Override
    public String toString() {
        return "AdNewsSet{" +
                "morningTime='" + morningTime + '\'' +
                ", eveningTime='" + eveningTime + '\'' +
                ", hasMorningOpen=" + hasMorningOpen +
                ", hasEveningOpen=" + hasEveningOpen +
                ", sendCount=" + sendCount +
                ", startContent='" + startContent + '\'' +
                ", endContent='" + endContent + '\'' +
                ", hasStartContent=" + hasStartContent +
                ", hasEndContent=" + hasEndContent +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", adNewsGroups=" + adNewsGroups +
                ", classifyIds=" + classifyIds +
                "} " + super.toString();
    }
}
