package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingClickRecordDao;
import com.pcloud.book.advertising.dao.AdvertisingPilotRecordDao;
import com.pcloud.book.advertising.dto.WechatGroupClickUserDTO;
import com.pcloud.book.advertising.entity.AdvertisingClickRecord;
import com.pcloud.book.advertising.entity.AdvertisingPilotRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description 广告位试听完成记录数据访问层接口实现类
 */
@Repository("advertisingPilotRecordDao")
public class AdvertisingPilotRecordDaoImpl extends BaseDaoImpl<AdvertisingPilotRecord> implements AdvertisingPilotRecordDao {


    @Override
    public Long getPilotUserNumByMasterId(Long masterId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("masterId", masterId);
        Long userNum = super.getSqlSession().selectOne(getStatement("getPilotUserNumByMasterId"),paramMap);
        return null == userNum ? 0L : userNum;
    }

    @Override
    public Long getPilotUserNumByQrcode(Long qrcodeId, Long adId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("qrcodeId", qrcodeId);
        paramMap.put("adId", adId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getPilotUserNumByQrcode"), paramMap);
    }

    @Override
    public Long getPilotUserNumByAdId(Long adId, Long bookId, Long adviserId, Long channelId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("adId", adId);
        paramMap.put("bookId", bookId);
        paramMap.put("adviserId", adviserId);
        paramMap.put("channelId", channelId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getPilotUserNumByAdId"), paramMap);
    }

    @Override
    public Long getPilotUserNumByBookId(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("adviserId", adviserId);
        paramMap.put("channelId", channelId);
        paramMap.put("adId", adId);
        paramMap.put("statisMonth", statisMonth);
        return getSessionTemplate().selectOne(getStatement("getPilotUserNumByBookId"), paramMap);
    }
}
