package com.pcloud.book.book.biz;

import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.vo.BookKeywordProductVO;
import com.pcloud.book.book.vo.request.AddBookKeywordRequestVO;
import com.pcloud.book.book.vo.request.CheckKeywordRequestVO;
import com.pcloud.book.book.vo.request.EditBookKeywordRequestVO;
import com.pcloud.book.book.vo.request.QueryBookKeywordWarehouseRequestVO;
import com.pcloud.book.book.vo.response.BookKeywordResponseVO;
import com.pcloud.book.keywords.vo.SetKeywordVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface BookKeywordWarehouseBiz {

    Long addBookKeyword(SetKeywordVO setKeywordVO);
    /**
     * 新增关键词
     */
    Long addBookKeyword(AddBookKeywordRequestVO vo, Integer useKeyword);

    /**
     * 修改关键词
     */
    void editBookKeyword(EditBookKeywordRequestVO vo);

    /**
     * 删除关键词
     */
    void deleteBookKeyword(Long keywordId, Long adviserId);

    /**
     * 关键词库查询
     */
    PageBeanNew<BookKeywordResponseVO> listBookKeywordWarehouse(QueryBookKeywordWarehouseRequestVO vo);

    /**
     * 使用关键词
     */
    void useKeyword(Long adviserId, Long keywordDetailId);

    /**
     * 查询关键词详情（去掉）
     */
    BookKeywordResponseVO getDetail(Long keywordId);

    /**
     * 常用关键词
     */
    PageBeanNew<BookKeywordProductVO> oftenKeyword(Integer currentPage, Integer numPerPage, Long bookGroupId, Long adviserId, Long depthLabelId, Long classifyId);

    /**
     * 热门关键词
     */
    PageBeanNew<BookKeywordProductVO> hotKeyword(Integer currentPage, Integer numPerPage, Long adviserId, Long bookGroupId, String keyword, Long depthLabelId, Long classifyId);

    /**
     * 审核关键词
     */
    void auditKeyword(Long partyId, Long keywordId, BookConstant.BookKeywordAuditEnum auditEnum);

    /**
     * 检查关键词是否重复
     */
    List<Long> checkKeyword(CheckKeywordRequestVO vo);


}
