package com.pcloud.book.consumer.settlement;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.settlementcenter.record.service.SettlementService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Component("settlementConsr")
public class SettlementConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(SettlementConsr.class);

   @Autowired
	private SettlementService settlementService;

	@ParamLog(value = "获取收益", isBefore = false, isAfterReturn = false)
	public Map<Long, BigDecimal> getWXGroupQrcodeIncomeByAdviser(List<Long> groupQrcodeIds, Long adviserId) throws BizException {
		if (ListUtils.isEmpty(groupQrcodeIds) || adviserId == null) {
			return null;
		}
		try {
			return ResponseHandleUtil.parseMapResponse(settlementService.getWXGroupQrcodeIncomeByAdviser(groupQrcodeIds, adviserId), Long.class, BigDecimal.class);
		} catch (Exception e) {
			LOGGER.error("获取收益.[getWXGroupQrcodeIncomeByAdviser]:" + e.getMessage(), e);
		}
		return null;
	}

	@ParamLog(value = "根据条件获取收益", isBefore = false, isAfterReturn = false)
	public Map<Long, BigDecimal> getAdviserIncomeByCondition(List<Long> ids, String type, Long partyId, Long groupQrcodeId, Long bookGroupId) throws BizException {
		Map<Long, BigDecimal> map = new HashMap<>();
		if (ListUtils.isEmpty(ids) || partyId == null) {
			return map;
		}
		try {
			ResponseEntity<ResponseDto<Map<Long, BigDecimal>>> responseEntityP = settlementService.getAdviserIncomeByCondition(ids, type, partyId, groupQrcodeId, bookGroupId);
			map = ResponseHandleUtil.parseMap(responseEntityP, Long.class, BigDecimal.class);
		} catch (Exception e) {
			LOGGER.error("获取收益.[getAdviserIncomeByCondition]:" + e.getMessage(), e);
		}
		return map;
	}
}
