package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.JoinGroupCipherDao;
import com.pcloud.book.group.dto.JoinGroupCipherDTO;
import com.pcloud.book.group.entity.JoinGroupCipher;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/8/5 16:18
 **/
@Component("joinGroupCipherDao")
public class JoinGroupCipherDaoImpl extends BaseDaoImpl<JoinGroupCipher> implements JoinGroupCipherDao {
    @Override
    public JoinGroupCipher getByWechatUserId(Long wechatUserId,Long classifyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("classifyId",classifyId);
        return this.getSqlSession().selectOne(this.getStatement("getByWechatUserId"), map);
    }

    @Override
    public JoinGroupCipher getByCipher(String cipher) {
        return this.getSqlSession().selectOne(this.getStatement("getByCipher"), cipher);
    }

    @Override
    public JoinGroupCipherDTO getDTOByCipher(String cipher) {
        return this.getSqlSession().selectOne(this.getStatement("getDTOByCipher"), cipher);
    }

    @Override
    public void updateCipherStateToUsed(String cipher, String wxId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cipher",cipher);
        map.put("wxId",wxId);
        this.getSqlSession().update(this.getStatement("updateCipherStateToUsed"), map);
    }

    @Override
    public List<JoinGroupCipherDTO> getClassifyIdsByWxIdAndAltId(String wxId, String altId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wxId",wxId);
        map.put("altId",altId);
        return this.getSqlSession().selectList(this.getStatement("getClassifyIdsByWxIdAndAltId"), map);
    }

    @Override
    public void updateQrcodeId(String cipher, String wxId, Long qrcodeId) {
        Map<String,Object> map=new HashMap<>();
        map.put("cipher",cipher);
        map.put("wxId",wxId);
        map.put("qrcodeId",qrcodeId);
        this.getSqlSession().update(this.getStatement("updateQrcodeId"), map);
    }
}
