package com.pcloud.book.advertising.service;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value = "pcloud-service-book", qualifier = "advertisingSpaceServiceCloud", path = "book/v1.0/advertisingSpaceService")
@Api(description = "广告位内部接口")
public interface AdvertisingSpaceService {

    /**
     * 每日凌晨计算昨日广告位收益
     * @throws BizException
     */
    @ApiOperation(value = "每日凌晨计算昨日广告位收益", httpMethod = "GET")
    @RequestMapping(value = "calculateAdvertisingIncomeYesterday", method = RequestMethod.GET)
    void calculateAdvertisingIncomeYesterday() throws BizException;
}
