package com.pcloud.book;

import com.alibaba.druid.pool.DruidDataSource;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.constant.MQTopicProducer;
import com.pcloud.common.core.mq.RabbitMQFactory;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Queue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import java.util.ArrayList;

import javax.sql.DataSource;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableAutoConfiguration
@ComponentScan("com.pcloud")
@EnableEurekaClient
@EnableFeignClients("com.pcloud")
@PropertySource({"classpath:properties/book.properties", "classpath:public_system.properties"})
@Configuration
@EnableSwagger2
public class BookApplication {

    public static void main(String[] args) {
        SpringApplication.run(BookApplication.class, args);
    }

    @Bean
    public Docket createRestApi() {// 创建API基本信息
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.pcloud"))// 扫描该包下的所有需要在Swagger中展示的API，@ApiIgnore注解标注的除外
                .paths(PathSelectors.any())
                .build();
    }

    @SuppressWarnings("deprecation")
    private ApiInfo apiInfo() {// 创建API的基本信息，这些信息会在Swagger UI中进行显示
        return new ApiInfoBuilder()
                .title("图书，融合版")// API 标题
                .description("图书，融合了spring-cloud & dubbo的接口")// API描述
                .contact("李莉")// 联系人
                .version("2.0.0")// 版本号
                .build();
    }

    @Bean
    public DataSource setDataSourceProperties(@Autowired DataSource dataSource) {
        ArrayList<String> arr = new ArrayList<>();
        arr.add("set names utf8mb4;");
        ((DruidDataSource) dataSource).setConnectionInitSqls(arr);
        return dataSource;
    }

    @Bean
    public Queue deleteVideoQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.DELETE_VIDEO);
    }

    @Bean
    public Binding deleteVideoBind() {
        return RabbitMQFactory.bindingExchange(deleteVideoQueue(), MQTopicProducer.DELETE_VIDEO);
    }

    @Bean
    public Queue chooseDefaultChannelQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.CHOOSE_DEFAULT_CHANNEL);
    }

    @Bean
    public Binding chooseDefaultChannelBind() {
        return RabbitMQFactory.bindingExchange(chooseDefaultChannelQueue(), MQTopicProducer.CHOOSE_DEFAULT_CHANNEL);
    }


    @Bean
    public Queue registerPartyQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.REGISTER_PARTY);
    }

    @Bean
    public Binding registerPartyBind() {
        return RabbitMQFactory.bindingExchange(registerPartyQueue(), MQTopicProducer.REGISTER_PARTY);
    }

    @Bean
    public Queue genuineQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.GENUINE);
    }

    @Bean
    public Binding genuineBind() {
        return RabbitMQFactory.bindingExchange(genuineQueue(), MQTopicProducer.GENUINE);
    }

    @Bean
    public Queue paymentQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.PAYMENT);
    }

    @Bean
    public Binding paymentBind() {
        return RabbitMQFactory.bindingExchange(paymentQueue(), MQTopicProducer.PAYMENT);
    }

    @Bean
    public Queue addWXGroupQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.ADD_WXGROUP);
    }

    @Bean
    public Binding addWXGroupBind() {
        return RabbitMQFactory.bindingExchange(addWXGroupQueue(), MQTopicProducer.ADD_WXGROUP);
    }

    @Bean
    public Queue wxGroupSendTextQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.WXGROUP_SEND_TEXT);
    }

    @Bean
    public Binding wxGroupSendTextBind() {
        return RabbitMQFactory.bindingExchange(wxGroupSendTextQueue(), MQTopicProducer.WXGROUP_SEND_TEXT);
    }

    @Bean
    public Queue pushAddUserMessage() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.PUSH_ADD_USER_MESSAGE);
    }

    @Bean
    public Binding pushAddUserMessageBind() {
        return RabbitMQFactory.bindingExchange(pushAddUserMessage(), MQTopicProducer.PUSH_ADD_USER_MESSAGE);
    }

    @Bean
    public Queue updateWXGroupNameQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.UPDATE_WXGROUP_NAME);
    }

    @Bean
    public Binding updateWXGroupNameBind() {
        return RabbitMQFactory.bindingExchange(updateWXGroupNameQueue(), MQTopicProducer.UPDATE_WXGROUP_NAME);
    }

    @Bean
    public Queue updateAppInfoQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.APP_UPDATE);
    }

    @Bean
    public Binding updateAppInfoBind() {
        return RabbitMQFactory.bindingExchange(updateAppInfoQueue(), MQTopicProducer.APP_UPDATE);
    }

    @Bean
    public Queue updateProductInfoQueue() {
        return RabbitMQFactory.queueBuilder(MQTopicConumer.PRODUCT_UPDATE);
    }

    @Bean
    public Binding updateProductInfoBind() {
        return RabbitMQFactory.bindingExchange(updateProductInfoQueue(), MQTopicProducer.PRODUCT_UPDATE);
    }
}
