package com.pcloud.book.advertising.dao.impl;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingClickRecordDao;
import com.pcloud.book.advertising.dto.WechatGroupClickUserDTO;
import com.pcloud.book.advertising.entity.AdvertisingClickRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位点击记录数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingClickRecordDao")
public class AdvertisingClickRecordDaoImpl extends BaseDaoImpl<AdvertisingClickRecord> implements AdvertisingClickRecordDao {

    /**
     * 微信群广告位点击读者列表
     */
    @Override
    public List<WechatGroupClickUserDTO> clickUserList4AdvertisingWechatGroup(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("clickUserList4AdvertisingWechatGroup"), paramMap);
    }
}
