package com.pcloud.book.clock.dao.impl;

import com.pcloud.book.clock.dao.BookClockInfoDao;
import com.pcloud.book.clock.dao.BookGroupClockDao;
import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.dto.BookClockListDTO;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.book.clock.entity.BookGroupClock;
import com.pcloud.common.core.dao.BaseDaoImpl;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:51
 * @Version 1.0
 */
@Repository("bookClockInfoDao")
public class BookClockInfoDaoImpl extends BaseDaoImpl<BookClockInfo> implements BookClockInfoDao {


    /**
     * 获取基本信息
     * @param bookClockInfoId
     * @return
     */
    @Override
    public BookClockInfoDTO getBaseInfoById(Long bookClockInfoId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getBaseInfoById"),bookClockInfoId);
    }

    /**
     * 修改作品/应用
     * @param paramMap
     */
    @Override
    public void updateBaseInfo4AppType(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.update(getStatement("updateBaseInfo4AppType"),paramMap);
    }

    /**
     * 修改基本信息(修改关键词)
     * @param paramMap
     */
    @Override
    public void updateBaseInfo4KeywordType(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.update(getStatement("updateBaseInfo4KeywordType"),paramMap);
    }

    /**
     * 获取基本信息
     * @param bookClockInfoId
     * @return
     */
    @Override
    public BookClockInfoDTO getBookGroupClockBaseInfo(Long bookClockInfoId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getBookGroupClockBaseInfo"),bookClockInfoId);
    }

    /**
     * 获取该编辑已选的超级作者作品及应用
     * @param adviserId
     * @return
     */
    @Override
    public List<BookClockInfoDTO> getOriginIdAndTypeByAdviserId(Long adviserId) {
        return super.sqlSessionTemplate.selectList(getStatement("getOriginIdAndTypeByAdviserId"),adviserId);
    }

    /**
     * 获取该作品/应用该编辑创建的基本信息
     * @param paramMap
     * @return
     */
    @Override
    public BookClockInfoDTO getBaseInfoByMap(Map<String,Object> paramMap) {
        return super.sqlSessionTemplate.selectOne(getStatement("getBaseInfoByMap"),paramMap);
    }

    @Override
    public PageBean listBookGroupClock(PageParam pageParam, Map<String, Object> paramMap) {
        paramMap.put("startNum", pageParam.getNumPerPage() * pageParam.getPageNum());
        paramMap.put("numPerPage", pageParam.getNumPerPage());
        List<BookClockListDTO> dtos = super.sqlSessionTemplate.selectList("listBookGroupClock", paramMap);
        Integer totalCount = super.sqlSessionTemplate.selectOne("countBookGroupClock", paramMap);
        return new PageBean(pageParam.getPageNum(), pageParam.getNumPerPage(), totalCount, new ArrayList<>(dtos));
    }

    /**
     * 修改作品信息
     * @param productId
     * @param title
     * @param coverImg
     * @param uniqueNumber
     */
    @Override
    public void updateProductInfo(Long productId, String title, String coverImg, String uniqueNumber) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("originId",productId);
        paramMap.put("title",title);
        paramMap.put("coverImg",coverImg);
        paramMap.put("uniqueNumber",uniqueNumber);
        super.sqlSessionTemplate.update(getStatement("updateProductInfo"),paramMap);
    }

    /**
     * 修改应用信息
     * @param appId
     * @param title
     * @param coverImg
     */
    @Override
    public void updateAppInfo(Long appId, String title, String coverImg) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("originId",appId);
        paramMap.put("title",title);
        paramMap.put("coverImg",coverImg);
        super.sqlSessionTemplate.update(getStatement("updateAppInfo"),paramMap);
    }


}
