package com.pcloud.book.keywords.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author lily
 * @date 2019/4/25 10:17
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListKeywordVO implements Serializable {

    @ApiModelProperty("设置关键词标识")
    private Long bookKeywordId;

    @ApiModelProperty("关键词标识")
    private Long keywordId;

    @ApiModelProperty("关键词")
    private String keywords;

    @ApiModelProperty("引导语")
    private String guide;

    @ApiModelProperty("匹配规则")
    private Integer matchingRule;

    @ApiModelProperty("回复类型")
    private Integer replyType;

    @ApiModelProperty("服务标识")
    private Long serveId;

    @ApiModelProperty("服务类型")
    private String serveType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("描述信息")
    private String description;

    @ApiModelProperty("排序")
    private Integer rank;

    public Long getBookKeywordId() {
        return bookKeywordId;
    }

    public void setBookKeywordId(Long bookKeywordId) {
        this.bookKeywordId = bookKeywordId;
    }

    public Long getKeywordId() {
        return keywordId;
    }

    public void setKeywordId(Long keywordId) {
        this.keywordId = keywordId;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getGuide() {
        return guide;
    }

    public void setGuide(String guide) {
        this.guide = guide;
    }

    public Integer getMatchingRule() {
        return matchingRule;
    }

    public void setMatchingRule(Integer matchingRule) {
        this.matchingRule = matchingRule;
    }

    public Integer getReplyType() {
        return replyType;
    }

    public void setReplyType(Integer replyType) {
        this.replyType = replyType;
    }

    public Long getServeId() {
        return serveId;
    }

    public void setServeId(Long serveId) {
        this.serveId = serveId;
    }

    public String getServeType() {
        return serveType;
    }

    public void setServeType(String serveType) {
        this.serveType = serveType;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    @Override
    public String toString() {
        return "ListKeywordVO{" +
                "bookKeywordId=" + bookKeywordId +
                ", keywordId=" + keywordId +
                ", keywords='" + keywords + '\'' +
                ", guide='" + guide + '\'' +
                ", matchingRule=" + matchingRule +
                ", replyType=" + replyType +
                ", serveId=" + serveId +
                ", serveType='" + serveType + '\'' +
                ", content='" + content + '\'' +
                ", picUrl='" + picUrl + '\'' +
                ", linkUrl='" + linkUrl + '\'' +
                ", description='" + description + '\'' +
                ", rank=" + rank +
                '}';
    }
}
