package com.pcloud.book.push.service.impl;

import com.pcloud.book.push.biz.PushBiz;
import com.pcloud.book.push.service.PushService;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/18 18:25
 **/
@RestController("pushService")
@RequestMapping("pushService")
public class PushServiceImpl implements PushService {

    private static final Logger LOGGER = LoggerFactory.getLogger(PushServiceImpl.class);

    @Autowired
    private PushBiz pushBiz;


    @ApiOperation("发送群消息")
    @PostMapping("/sendGroupMessage")
    @Override
    public void sendGroupMessage(@RequestBody Map<String, Object> map) throws BizException {
        LOGGER.info("内部接口群发消息被调用"+map.toString());
        pushBiz.sendGroupMessage(new Long(map.get("pushId").toString()));
    }
}
