package com.pcloud.common.core.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * 
 * @描述：发消息的模板
 * @作者：zhuyajie
 * @创建时间：2016年11月24日 下午3:03:29
 * @版本：1.0
 */
public class SendNotifyDto implements Serializable{

	private static final long serialVersionUID = 8126368438145312971L;
	/**
	 * 发送者标识
	 */
	private Long fromId;
	
	/**
	 * 接收者标识
	 */
	private Long toId;
	
	/**
	 * 通知内容
	 */
	private String  notifyContent;
	/**
	 * 发布时间
	 */
	private Date createdTime;
	/**
	 * 消息类型
	 */
	private String typeCode;
	/**
	 * 接收方系统标识
	 */
	private String systemCode;
	/**
	 * 资源标识
	 */
	private String resourceId;
	/**
	 * 应用类型
	 */
	private String appType;
	/**
	 * 应用场景
	 */
	private String sceneCode;
	/**
	 * 跳转链接
	 */
	private String url;
	/**
	 * app
	 */
	private int isApp;
	/**
	 * 手机管理端
	 */
	private int isWechat;
	/**
	 * 小程序
	 */
	private int isWxApp;
	/**
	 * 下载文件名
	 */
	private  String fileName;
	/**
	 * 接收者id列表
	 */
	private List<Long> idList;
	/**
	 * 弹窗消息截止日期
	 */
	private Date indate;
	/**
	 * 弹窗图片
	 */
	private String pic;
	/**
	 * 弹窗频率
	 */
	private Integer frquency;
	/**
	 * json字符串
	 */
	private String jsonString;

	/**
	 * 来源ID
	 * @return
	 */
	private String originId;

	/**
	 * 来源类型
	 * @return
	 */
	private String originType;

	public Long getFromId() {
		return fromId;
	}
	public void setFromId(Long fromId) {
		this.fromId = fromId;
	}
	public Long getToId() {
		return toId;
	}
	public void setToId(Long toId) {
		this.toId = toId;
	}
	public String getNotifyContent() {
		return notifyContent;
	}
	public void setNotifyContent(String notifyContent) {
		this.notifyContent = notifyContent;
	}
	public Date getCreatedTime() {
		return createdTime;
	}
	public void setCreatedTime(Date createdTime) {
		this.createdTime = createdTime;
	}
	public String getTypeCode() {
		return typeCode;
	}
	public void setTypeCode(String typeCode) {
		this.typeCode = typeCode;
	}
	public String getSystemCode() {
		return systemCode;
	}
	public void setSystemCode(String systemCode) {
		this.systemCode = systemCode;
	}
	public String getResourceId() {
		return resourceId;
	}
	public void setResourceId(String resourceId) {
		this.resourceId = resourceId;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getAppType() {
		return appType;
	}
	public void setAppType(String appType) {
		this.appType = appType;
	}

	public String getSceneCode() {
		return sceneCode;
	}

	public void setSceneCode(String sceneCode) {
		this.sceneCode = sceneCode;
	}

	public int getIsApp() {
		return isApp;
	}
	public void setIsApp(int isApp) {
		this.isApp = isApp;
	}
	public int getIsWechat() {
		return isWechat;
	}
	public void setIsWechat(int isWechat) {
		this.isWechat = isWechat;
	}
	public int getIsWxApp() {
		return isWxApp;
	}
	public void setIsWxApp(int isWxApp) {
		this.isWxApp = isWxApp;
	}
	public String getFileName() {
		return fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public List<Long> getIdList() {
		return idList;
	}

	public void setIdList(List<Long> idList) {
		this.idList = idList;
	}

	public Date getIndate() {
		return indate;
	}

	public void setIndate(Date indate) {
		this.indate = indate;
	}

	public String getPic() {
		return pic;
	}

	public void setPic(String pic) {
		this.pic = pic;
	}

	public Integer getFrquency() {
		return frquency;
	}

	public void setFrquency(Integer frquency) {
		this.frquency = frquency;
	}

	public String getJsonString() {
		return jsonString;
	}

	public void setJsonString(String jsonString) {
		this.jsonString = jsonString;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public String getOriginType() {
		return originType;
	}

	public void setOriginType(String originType) {
		this.originType = originType;
	}

	public String getOriginId() {
		return originId;
	}

	public void setOriginId(String originId) {
		this.originId = originId;
	}

	@Override
	public String toString() {
		return "SendNotifyDto{" +
				"fromId=" + fromId +
				", toId=" + toId +
				", notifyContent='" + notifyContent + '\'' +
				", createdTime=" + createdTime +
				", typeCode='" + typeCode + '\'' +
				", systemCode='" + systemCode + '\'' +
				", resourceId='" + resourceId + '\'' +
				", appType='" + appType + '\'' +
				", sceneCode='" + sceneCode + '\'' +
				", url='" + url + '\'' +
				", isApp=" + isApp +
				", isWechat=" + isWechat +
				", isWxApp=" + isWxApp +
				", fileName='" + fileName + '\'' +
				", idList=" + idList +
				", indate=" + indate +
				", pic='" + pic + '\'' +
				", frquency=" + frquency +
				", jsonString='" + jsonString + '\'' +
				", originId='" + originId + '\'' +
				", originType='" + originType + '\'' +
				'}';
	}
}
