package com.pcloud.common.core.tools;

import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.google.common.collect.Maps;
import com.pcloud.common.core.enums.ProductTypeEnum;
import com.pcloud.common.core.enums.TempletCodeEnum;
import com.pcloud.common.enums.AppTypeEnum;
import com.pcloud.common.utils.string.StringUtil;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年10月31日,下午7:22:15
 * @版本：1.0
 */
public class TempletTools {
	
	/**
	 * 名称
	 */
	public static final String NAME = "name";
	
	/**
	 * 简介
	 */
	public static final String REMARK = "remark";
	
	/**
	 * 封面图
	 */
	public static final String COVER_IMG = "coverImg";
	
	/**
	 * 宣传图
	 */
	public static final String SPREAD_IMG = "spreadImg";
	
	/**
	 * 协议价
	 */
	public static final String DEAL_PRICE = "dealPrice";
	
	/**
	 * 销售价
	 */
	public static final String RETAIL_PRICE = "retailPrice";
	
	/**
	 * 开始时间
	 */
	public static final String START_DATE = "startDate";
	
	/**
	 * 结束时间
	 */
	public static final String END_DATE = "endDate";
	
	/**
	 * 根据模板编码初始化时基本信息
	 * 
	 * @param app
	 * @param templetCode
	 * @return
	 */
	public static Map<String, Object> getAppInfo(String templetCode, String fromCode, String typeCode, String index) {
		if (StringUtil.isEmpty(templetCode)) {
			return null;
		}
		Map<String, Object> resultMap = Maps.newHashMap();
		if (TempletCodeEnum.K12.name().equals(templetCode)) {
			setK12(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.PUBLIC_PROSE.name().equals(templetCode)) {
			setPublicProse(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.PUBLIC_JOURNAL.name().equals(templetCode)) {
			setPublicJournal(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.PUBLIC_NOVEL.name().equals(templetCode)) {
			setPublicNovel(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.SINOLOGY.name().equals(templetCode)) {
			setSinology(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.VACATION.name().equals(templetCode)) {
			setVacation(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.MILITARY.name().equals(templetCode)) {
			setMilitary(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.IMPORTED_HIGER.name().equals(templetCode)) {
			setImportedHiger(resultMap, fromCode, typeCode, index);
		} else if (TempletCodeEnum.IMPORTED_SMALL.name().equals(templetCode)) {
			setImportedSmall(resultMap, fromCode, typeCode, index);
		} else if (TempletCodeEnum.GERIATRIC.name().equals(templetCode)) {
			setGeriatric(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.EXTRACURRICULAR.name().equals(templetCode)) {
			setExtracurricular(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.CELEBRITY.name().equals(templetCode)) {
			setCelebrity(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.CHILD_PUFFIN.name().equals(templetCode)) {
			setChildPuffin(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.CHILD_SINOLOGY.name().equals(templetCode)) {
			setChildSinology(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.CHILD_INTEREST.name().equals(templetCode)) {
			setChildInterest(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.PROFESSIONAL.name().equals(templetCode)) {
			setProfessional(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.SCIENCE.name().equals(templetCode)) {
			setScience(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.PROMOTE.name().equals(templetCode)) {
			setPromote(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.SPECIAL_SMALL.name().equals(templetCode)) {
			setSpecialSmall(resultMap, fromCode, typeCode);
		} else if (TempletCodeEnum.SPECIAL_HIGER.name().equals(templetCode)) {
			setSpecialHiger(resultMap, fromCode, typeCode);
		} else {
			return null;
		}
		if (!MapUtils.isEmpty(resultMap)) {
			resultMap.put(TempletTools.START_DATE, "2017-09-01");
			resultMap.put(TempletTools.END_DATE, "2999-12-31");
		}
		return resultMap;
	}
	
	/**
	 * 设置K12模板应用信息
	 * 
	 * @param app
	 */
	private static void setK12(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "备考提升圈|与数万尖子生交流备考、提升经验");
			resultMap.put(TempletTools.REMARK, "想快速掌握答题技巧吗？想获取最权威的学习资料吗？想了解重难点题型的解答过程吗？\n欢迎加入本书备考提升圈。"
					+ "作为出版社官方的学习交流圈，在这里本书的作者和编辑将为每一位读者提供最具时效性、权威的一手学习资源。包括但不限于："
					+ "\n1.本书的配套答案，快速检测答题准确率；\n2.本学期教学辅导资料,让读者掌握第一手备考资源，冲向高分；\n3.重难点题型解答，"
					+ "快速掌握重难点解题技巧；\n4.拔高小练习，巩固基础知识的同时提升应试能力。\n各项资源服务分类明确，且针对性强。并能让各位读者们与数万尖子生" 
					+ "交流提升方法，获取备考经验、心得。");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/c203ef906cb087d67e2179a76423ed9f.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/png/078cae9832b24cf8c08fb601a4aed224.png");
		} else if (AppTypeEnum.ZSCORE.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "查看每套试卷得分排名");
			resultMap.put(TempletTools.REMARK, "查看每套试卷得分排名");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/70a1655a62334fa9bc452de63231d61a.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/db24dc12d0406363bd00d52893addac4.jpg");
		} else if (AppTypeEnum.QA.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "在线名师答疑，你的解题神器");
			resultMap.put(TempletTools.REMARK, "在线名师答疑，你的解题神器");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a12ab2db086c2ea488765c743efc9411.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/4023edf7c87dc08e08d8498b0062c1c4.jpg");
		} else if (AppTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "本书拔高题，一题加5分");
			resultMap.put(TempletTools.REMARK, "本书拔高题，一题加5分");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/db8cfc4898be631a005ef9c474289650.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://file.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		}
	}
	
	/**
	 * 大众类散文随笔诗歌
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setPublicProse(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "本书品读圈|与千万书友分享美文，交流阅读心得");
			resultMap.put(TempletTools.REMARK,	"欢迎大家加入本书品读圈。本圈旨在为各读者、编辑、作者之间构建一个活跃、丰富的话题讨论氛围。"
					+ "在这里，您可以与志趣相投的小伙伴分享您的阅读感受，和编辑老师探讨本书的相关章节，与作者一起互动，了解本书的创作心"
					+ "路。\n此外，本圈还会提供基于本书的线上衍生资源和读者服务，包括但不限于\n1、本书及本书作者的经典词句摘"
					+ "录；\n2、本书作者寄语；\n3、本书原版手稿；\n4、文章音频等。\n上述内容" 
					+ "将不定期持续更新，让读者在深度的阅读中，品味独属于散文或澎湃或娴雅的美。");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/4cbcd77047d5af524b635c5f1d9c411f.jpg");
		}
	}
	
	/**
	 * 大众类期刊
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setPublicJournal(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "读者交流圈|与千万读者深入交流、分享见闻");
			resultMap.put(TempletTools.REMARK, "欢迎您加入本刊读者交流圈，本圈旨在为各位读者提供一个互动交流的平台。在这里，您可以与许多志"
					+ "同道合的朋友分享阅读心得、共话社会动态。\n您还可以在这里：\n1、挖掘本刊文章背后的故事；\n2、获取独家采访音视" 
					+ "频\n本刊读者圈的服务包括但不限于此，以上内容将不定时更新！");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/c203ef906cb087d67e2179a76423ed9f.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpeg/3e0b401b600816df4752643aae850183.jpeg");
		} else if (ProductTypeEnum.FORMAT.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【线上增刊】点击进入+线上增刊品牌名");
			resultMap.put(TempletTools.REMARK, "【线上增刊】点击进入+线上增刊品牌名");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 10.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpeg/3e0b401b600816df4752643aae850183.jpeg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpeg/3e0b401b600816df4752643aae850183.jpeg");
		} 
	}
	
	/**
	 * 大众类小说
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setPublicNovel(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "本书剧情交流圈|与作者近距离互动，同千万书迷讨论书中隐藏剧情");
			resultMap.put(TempletTools.REMARK,
					"亲爱的各位读者，你们好！欢迎加入本书剧情交流圈。\n本读者圈旨在为本书的读者们、书迷们和作者（编辑）"
							+ "打造一个自由交流感想、讨论剧情、分享收获的天地。\n除此之外，本读者圈将持续不定期的推出本书衍生的内容及服务来不断帮助读者加深对故事内容"
							+ "的理解和认知，包括但不限于：\n1.、书中未公布的隐藏剧情，打开你的好奇心；\n2、本书的创作背景以及作者的心路历程，带你追忆旧时"
							+ "的风土人情；\n3、人物关系图谱，让你迅速了解人物特性，洞察情节走向；\n4、全书音频保存至手机，方便携带，让碎片化时间也能充实起来；\n5、争"
							+ "议话题讨论，在这里或是抒发情感，或是舌战群儒，或是大力吐槽等等，看作者大咖如何来为你指点迷津。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/56102c76d49597fa5e8a38d750789203.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/56102c76d49597fa5e8a38d750789203.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "《本书》后续章节+番外剧情");
			resultMap.put(TempletTools.REMARK,	"《本书》后续章节+番外剧情");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8abc76ce5a7b2a28286a27fb42dced95.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/ca2d8be2793cde6d0ffc9ba043254851.jpg");
		}
	}
	
	/**
	 * 国学类图书(18+)
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setSinology(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "本书品读圈|与千万读者共赏国学之美");
			resultMap.put(TempletTools.REMARK,
					"欢迎有国学爱好的朋友们踊跃加入国学品读圈，讨论国学新热点，分享国学讲座资讯，以文会友。作为最活跃的国学品读圈，我们提倡新国学、"
							+ "新知识、新生活，植根于现代大都市，坚守繁华市中心。\n为了帮助各位读者深度理解国学，本读者圈将提供衍生内容及服务，包括但不限于：\n1.给读者的伴读指"
							+ "南，含本书阅读指导，帮你快速读懂国学名作，成为国学大师；\n2.章节最美译文，读者们可以晒出此书中自己认为最美的译文，上传后就有可能提名上榜，成为最受"
							+ "欢迎国学爱好者；\n3.名家偏爱的经典桥段，为您提供最IN的写作素材；\n4.名家朗读经典国学选段音频，迅速带你到历史场景，让你的阅读更加流畅。\n国学读者"
							+ "圈是国学爱好者的集散地，给读者普及国学新知识，让你了解传统文化，欢迎大家畅所欲言。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/c54ab8e26510d79e279b4ebeed715bec.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/58c23cc7082df1cb8b89b095097913ec.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "最能突显人文素养、适合职场引用的名段");
			resultMap.put(TempletTools.REMARK, "最能突显人文素养、适合职场引用的名段");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/d64f8086430e9a5aa2e4ce9892ec4d95.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		}
	}
	
	/**
	 * 假期作业
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setVacation(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "假期亲子教育学习圈");
			resultMap.put(TempletTools.REMARK,
					"欢迎加入本书假期亲子教育学习圈。作为出版社官方的学习交流圈，本书编辑将在这里为每一位读者提供最具时效性、最权威的一手学习资源。包括但不限\n"
							+ "1.本书的配套答案，快速检测答题准确率；\n2.本学期教学辅导资料，让家长掌握第一手资源，辅导更方便；\n3.拔高小练习，巩固基础知"
							+ "识的同时提升应试能力；\n各项资源服务分类明确，且针对性强。家长们可以在这里交流提升孩子学习成绩的方法、心得。（注：以上服务将不定期更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/png/faf70ee996dc98a96770c4c249d6c9eb.png");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/d4084f47863a1178b0245bf129ff9b02.jpg");
		} else if (AppTypeEnum.SPECIAL.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "给爸爸妈妈的假期作业");
			resultMap.put(TempletTools.REMARK, "给爸爸妈妈的假期作业");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/50c1b142e98f6b397bb79e6e18997b25.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/e5cea060dda4b8ea4fa7cbdb149b0fb2.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "把答案保存到手机上，帮孩子检查作业");
			resultMap.put(TempletTools.REMARK, "把答案保存到手机上，帮孩子检查作业");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/ef554210f78bd6f5883843930189d16a.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8afad0ed1cdf8b4a407b2a16dafba88a.jpg");
		} else if (ProductTypeEnum.PRETEST.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "爸妈每周考孩子两道题，定期巩固上学期知识点");
			resultMap.put(TempletTools.REMARK, "爸妈每周考孩子两道题，定期巩固上学期知识点");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/09721e67cfb5091d492e17b96c90d789.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8afad0ed1cdf8b4a407b2a16dafba88a.jpg");
		}
	}
	
	/**
	 * 军事历史类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setMilitary(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【铁血军迷互动圈】与千万书迷深入解密关键事件、战役背后的真相");
			resultMap.put(TempletTools.REMARK,
					"本读者圈旨在为本书的读者们、书迷们和作者（编辑）打造一个自由交流感想、讨论剧情、分享收获的天地，我们将持续不定期的推出本书衍生的内"
							+ "容及服务来不断帮助读者加深对故事内容的理解和认知，包括但不限于：\n1、书中未公布的隐藏剧情，打开你的好奇心；\n2、书中关键事件/关键战役的深层次描述，或作者"
							+ "观点；\n3、书中关键人物生平，及书中内容之后的动向（升官、被打压、羁押等）让你迅速了解人物特性，洞察情节走向；\n4、争议话题讨论，在这里或抒发情感，或舌战群儒"
							+ "，看作者大咖如何为你指点迷津。");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/4c69d5e26a4a1d02a046550b052606a4.jpg");
		} else if (ProductTypeEnum.AUDIO.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【独家音频】历史事件核心解读");
			resultMap.put(TempletTools.REMARK, "【独家音频】历史事件核心解读");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/b8ba6e45bcddc34531d3c8715315ea93.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/d497110b7636504ed32419ff372e34ae.jpg");
		}
	}
	
	/**
	 * 教材教辅类（高中）
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setImportedHiger(Map<String, Object> resultMap, String fromCode, String typeCode, String index) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "备考提升圈丨与数万尖子生交流学习方法");
			resultMap.put(TempletTools.REMARK, "想快速掌握答题技巧吗？想获取最权威的学习资料吗？想了解重难点题型的解答过程吗？欢迎加入本书备考提升圈。作为出版社官方的学习交流圈"
					+ "，本书的作者和编辑，将为每一位读者提供时下最具时效性的、权威的一手学习资源。包括但不限于：\n1、本书的配套答案，快速检测答题准确率；\n2、本学期教学辅导资"
					+ "料，让读者掌握第一手备考资源，冲向高分；\n3、重难点题型解答，快速掌握重难点解题技巧；\n4、拔高小练习，巩固基础知识的同时提升应试能力；\n5、名师授课教学视"
					+ "频，打开读者的解题思路，从而掌握一道题，解决一类题。\n各项资源服务分类明确，且针对性强。并能让各位读者们与数万尖子生交流提升方法，获取备考经验、心得。"
					+ "（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/fd39dee6ee2c6a7a137f4fb9f59bf505.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode) && "1".equals(index)) {
			resultMap.put(TempletTools.NAME, "疯狂拿分丨各单元难点解析，帮你考试拿高分");
			resultMap.put(TempletTools.REMARK, "疯狂拿分丨各单元难点解析，帮你考试拿高分");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 2.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8b9e08bc2c2204445e9ffcb9e86f1a73.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode) && "2".equals(index)) {
			resultMap.put(TempletTools.NAME, "把握难点丨老师的教案给你看，梳理重要知识点");
			resultMap.put(TempletTools.REMARK, "把握难点丨老师的教案给你看，梳理重要知识点");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/2b00d98a07570c9d1829fc573dde0c46.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		}
	}
	
	/**
	 * 教材教辅类（小学初中）图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setImportedSmall(Map<String, Object> resultMap, String fromCode, String typeCode, String index) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "备考提升圈丨让家长与作者互动，帮助孩子考试轻松拿高分");
			resultMap.put(TempletTools.REMARK,
					"想快速掌握答题技巧吗？想获取最权威的学习资料吗？想了解重难点题型的解答过程吗？欢迎加入本书备考提升圈。"
							+ "作为出版社官方的学习交流圈，每一位圈主即本书的作者和编辑，将为每一位读者提供时下最热门、权威的一手学习资源。包括但不限于：\n1、"
							+ "本书的配套答案，快速检测答题准确率；\n2、本学期教学辅导资料，让读者掌握第一手备考资源，冲向高分；\n3、重难点题型解答，快速掌握重难"
							+ "点解题技巧；\n4、拔高小练习，巩固基础知识的同时提升应试能力；\n5、名师授课教学视频，打开读者的解题思路，从而掌握一道题，解决一类题。"
							+ "\n各项资源服务分类明确，且针对性强。并能让各位读者们与数万尖子生交流提升方法，获取备考经验、心得。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/e6b4dcb525e9442c5fe4978889159056.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode) && "1".equals(index)) {
			resultMap.put(TempletTools.NAME, "疯狂拿分丨各单元难点解析，考试重点提前掌握");
			resultMap.put(TempletTools.REMARK, "疯狂拿分丨各单元难点解析，考试重点提前掌握");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 2.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8b9e08bc2c2204445e9ffcb9e86f1a73.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode) && "2".equals(index)) {
			resultMap.put(TempletTools.NAME, "把握难点丨老师的教案给你看，梳理重要知识点");
			resultMap.put(TempletTools.REMARK, "把握难点丨老师的教案给你看，梳理重要知识点");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/2b00d98a07570c9d1829fc573dde0c46.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		}
	}
	
	/**
	 * 老年大学教材
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setGeriatric(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【点我】加入老年大学校友圈 ，秀出你的学习成果");
			resultMap.put(TempletTools.REMARK,
					"欢迎加入老年大学校友圈。作为出版社官方的学习交流圈，每一位圈主即是本书的作者和编辑，将为每一位读者提供时下热门、权威的一手学习资源。"
							+ "包括但不限于：\n 1.本书的配套音频、视频；\n 2.重难点题动作示范，快速掌握技巧；\n 3.名师授课教学视频，丰富您的业余"
							+ "生活。 \n各项资源服务分类明确，且针对性强。并能让各位读者们一起交流提升方法，分享快乐生活。\n （注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/png/f4a04acfa9ede7ade68e7d9542476452.png");
		} else if (ProductTypeEnum.AUDIO.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【音频】课本配套音频，在家也能学");
			resultMap.put(TempletTools.REMARK, "【音频】课本配套音频，在家也能学");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 0.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/png/855c609173dccec374323476f427b62c.png");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/png/855c609173dccec374323476f427b62c.png");
		} else if (ProductTypeEnum.VIDEO.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【视频】跟着专业老师练，动作更标准");
			resultMap.put(TempletTools.REMARK, "【视频】跟着专业老师练，动作更标准");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/9a3a896de6eae595a5b27c34d323f920.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/9a3a896de6eae595a5b27c34d323f920.jpg");
		}
	}
	
	/**
	 * 课外读本类
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setExtracurricular(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "加入课外阅读圈，与数万书迷探讨书中隐藏剧情");
			resultMap.put(TempletTools.REMARK, "欢迎加入本书读者圈。本书读者圈现已开启，期待您的踊跃加入！在这里，您可以获取书中的隐藏小剧情，激发您的求知欲和好奇心，"
					+ "让你对阅读产生兴趣，提升你的阅读和理解的能力，从中获取写作素材。另外，您还可以与数万书迷探讨书中的隐秘情节，并且还有本书作者带领大家一起" 
					+ "讨论书中剧情，欢迎大家畅所欲言。");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/png/03683eadb7555baeeaa455307a163dfb.png");
		} else if (AppTypeEnum.KK.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "看你扫到书中哪一个人物角色？");
			resultMap.put(TempletTools.REMARK, "看你扫到书中哪一个人物角色？");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/0497fc4a36685e4147b9196cf050fb60.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/795ff71a2036f3a34efcd582d4edd076.jpg");
		} 
	}
	
	/**
	 * 名人传记类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setCelebrity(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【点我】加入大咖圈，揭秘名人不为多数人所知的故事");
			resultMap.put(TempletTools.REMARK, "欢迎您加入名人大咖圈，本读者圈旨在为各位读者提供一个互动交流的平台。在这里，您可以与许多志同道合的书友分享读书心得、"
					+ "共话行业动态。 您还可以在这里： \n1、交流了解名人生平事迹； \n2、查看名人人际关系脉络图； \n3、学习他的处世哲学； 读者圈的服务包括但不限于此，以上内容将不定时更新！");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/083f44f169705a0d83bda683f9a4e78d.jpg");
		} else if (ProductTypeEnum.ALBUM.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【重磅推荐】收藏名人成长相册，重温他的成长足迹");
			resultMap.put(TempletTools.REMARK, "【重磅推荐】收藏名人成长相册，重温他的成长足迹");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/26b1d7a96ebc8a6c07ccbfa25bc9b27a.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/26b1d7a96ebc8a6c07ccbfa25bc9b27a.jpg");
		}
	}
	
	/**
	 * 少儿读物类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setChildPuffin(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【点我】加入少儿阅读扩展圈");
			resultMap.put(TempletTools.REMARK,
					"亲爱的各位读者，你们好！这里是少儿阅读扩展圈，期待你们的加入。\n本读者圈旨在为本书的读者们、书迷们和作者（编辑）打造一个自由交流感想、"
							+ "讨论剧情、分享收获的天地。\n除此之外，本读者圈将持续不定期的推出本书衍生的内容及服务来不断帮助读者加深对故事内容的理解和认知，包括但不限于：\n"
							+ "1.、书中未公布的隐藏剧情，打开你的好奇心；\n2、本书的创作背景以及作者的心路历程，带你追忆旧时的风土人情；\n"
							+ "3、人物关系图谱，让你迅速了解人物特性，洞察情节走向；\n4、全书音频保存至手机，方便携带，让碎片化时间也能充实起来；\n"
							+ "5、争议话题讨论，在这里或是抒发情感，或是舌战群儒，或是大力吐槽等等，看作者大咖如何来为你指点迷津。");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/c203ef906cb087d67e2179a76423ed9f.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/png/7aabb758edba6efa1cad6a42d042ba51.png");
		} else if (ProductTypeEnum.AUDIO.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【故事音频】看书累了？让知名主播读给你听");
			resultMap.put(TempletTools.REMARK, "【故事音频】看书累了？让知名主播读给你听");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8f8eb7ebe34d1091b5c89e8f6383e156.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8f8eb7ebe34d1091b5c89e8f6383e156.jpg");
		} else if (AppTypeEnum.KK.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【扫扫看】我居然是书中的他•••••");
			resultMap.put(TempletTools.REMARK, "【扫扫看】我居然是书中的他•••••");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/0497fc4a36685e4147b9196cf050fb60.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/e1d4f047e7eb792ee7505a21fbf7fd98.jpg");
		}
	}
	
	/**
	 * 少儿国学类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setChildSinology(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "本书品读圈|与万千读者共享国学之美");
			resultMap.put(TempletTools.REMARK,
					"欢迎各位家长加入国学品读圈，讨论国学伴读方法，分享伴读经验。作为最活跃的国学品读圈，我们提倡新国学、新知识、新生活，植根于现代大都市，坚守繁华市中心。"
							+ "为了帮助各位父母能更好的与孩子一起伴读，本读者圈将提供衍生内容及服务，包括但不限于：\n1.给父母的伴读指南，含本书阅读指导，帮孩子快速读懂"
							+ "国学名作，成为国学小名家；\n2.章节最美译文，父母们可以晒出此书中自己认为最美的译文，上传后就有可能提名上榜，成为最受欢迎国学爱好者；\n3.名家"
							+ "偏爱的经典桥段，为孩子提供最IN的写作素材；\n4.名家朗读经典国学选段音频，带孩子畅游历史场景，让父母伴读更加流畅。\n国学品读圈是国学爱好者的集"
							+ "散地，给孩子普及国学新知识，让孩子了解传统文化，欢迎大家畅所欲言。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/c203ef906cb087d67e2179a76423ed9f.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/78f8fc64dfa368d1696d96151e296582.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "本书中最常被名家名篇引用的15个经典桥段");
			resultMap.put(TempletTools.REMARK, "本书中最常被名家名篇引用的15个经典桥段");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/d64f8086430e9a5aa2e4ce9892ec4d95.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/5e904c9447e689cf11da85672b1df6c7.jpg");
		}
	}
	
	/**
	 * 少儿兴趣学习类
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setChildInterest(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "加入本书亲子伴读圈，与千万家长交流亲子互动经验");
			resultMap.put(TempletTools.REMARK,
					"各位家长们好，本书亲子伴读圈已开启，期待您的踊跃加入！在这里，您可以获取编委会名师独家制作的配套内容服务，包括但不限于：\n"
							+ "1、书中的隐藏小剧情，激发孩子的求知欲和好奇心，让孩子对阅读产生兴趣，提升孩子阅读和理解的能力。\n2、编委会名师根据本书编写的亲子趣味互动"
							+ "交流题，让您不用翻书也能知道故事内容，并与孩子深度交流，检测孩子们对故事的记忆和理解程度，培养孩子动手、动脑好习惯。"
							+ "\n3、您还可以与数万的家长交流探讨孩子在成长中的问题与教育心得，用最合适的方式培育孩子茁壮成长。\n（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/4b684b460cf9c56918f1142bbdacf0c1.jpg");
		} else if (ProductTypeEnum.WORD.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "看单词记忆卡片，对孩子开展启蒙教育");
			resultMap.put(TempletTools.REMARK, "看单词记忆卡片，对孩子开展启蒙教育");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8fde07f536b5969612cdc48fcb92eb9e.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/50c1b142e98f6b397bb79e6e18997b25.jpg");
		}
	}
	
	/**
	 * 职教、专业技术类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setProfessional(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "加入备考提升圈，获取往年真题，把握命题规律");
			resultMap.put(TempletTools.REMARK,
					"想快速掌握答题技巧吗？想获取最权威的学习资料吗？想了解重难点题型的解答过程吗？\n"
							+ "欢迎加入本书备考提升圈。作为出版社官方的学习交流圈，本书的作者和编辑，将为每一位读者提供最具时效性的、权威的一手学习资源。包括但不限于："
							+ "\n1.本书的配套答案，快速检测答题准确率；\n2.本学期教学辅导资料,让读者掌握第一手备考资源，冲向高分；\n3.重难点题型解答，"
							+ "快速掌握重难点解题技巧；\n4.拔高小练习，巩固基础知识的同时提升应试能力；\n5.名师授课教学视频,打开读者的解题思路，从而掌握一道题，解决一类题。\n"
							+ "各项资源服务分类明确，且针对性强。并能让各位读者们与数万尖子生交流提升方法，获取备考经验、心得。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/11202974d23d5bdd1b5aa5db0d5fbb38.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【考前必看】10个必背知识点");
			resultMap.put(TempletTools.REMARK, "【考前必看】10个必背知识点");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/2b00d98a07570c9d1829fc573dde0c46.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		}
	}
	
	/**
	 * 生活科普类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setScience(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "加入生活科普交流圈，获取权威生活百科");
			resultMap.put(TempletTools.REMARK,
					"亲爱的各位读者，你们好！这里是生活科普交流圈，期待你们的加入。\n本读者圈旨在为本书的读者们、书迷们和作者（编辑）打造一个自由交"
							+ "流感想、讨论剧情、分享收获的天地。\n除此之外，本读者圈将持续不定期的推出本书衍生的内容及服务来不断帮助读者加深对故事内容的理解和认知，"
							+ "包括但不限于：\n1.、书中未公布的生活科普小知识，为大家生活提供更多便捷；\n2、全书音频保存至手机，方便携带，让碎片化时间也能充实起来；"
							+ "\n3、争议话题讨论，在这里或是抒发情感，或是舌战群儒，或是大力吐槽等等，看作者大咖如何来为你指点迷津。");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/55fc7d2e4696b8293c24b0d84e0a8945.jpg");
		} else if (AppTypeEnum.KK.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "作者独家提供10个生活小知识，你会抽中哪个？");
			resultMap.put(TempletTools.REMARK, "作者独家提供10个生活小知识，你会抽中哪个？");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/e1d4f047e7eb792ee7505a21fbf7fd98.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/e1d4f047e7eb792ee7505a21fbf7fd98.jpg");
		}
	}
	
	/**
	 * 提升类图书
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setPromote(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【点我】加入本书行业精英交流圈");
			resultMap.put(TempletTools.REMARK, "欢迎您加入本书读者圈，本读者圈旨在为各位读者提供一个互动交流的平台。在这里，您可以与许多志同道合的书友分享读书心得、共话行业动态。"
					+ "甚至您将有机会向作者提问，与作者共同一起针对最新案例结合本书内容展开讨论，以前瞻眼光洞察行业发展。\n您还可以在这里：\n"
					+ "1、交流了解行业“黑话”；\n2、查看案例视频；\n3、学习最新案例，并将职场专业工具包收入囊中；\n读者圈的服务包括但不限于此，以上内容将不定时更新" 
					+ "，以助您驰骋职场一臂之力！");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/c54ab8e26510d79e279b4ebeed715bec.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/643bc055332a17ec162fef03eeda34b9.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "【独家】职场专业工具包，助你“加薪”快人一步");
			resultMap.put(TempletTools.REMARK, "【独家】职场专业工具包，助你“加薪”快人一步");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/2b00d98a07570c9d1829fc573dde0c46.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		}
	}
	
	/**
	 * 专题类教材教辅（小学、初中）
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setSpecialSmall(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "加入备考提升圈，获取名师重难点点拨");
			resultMap.put(TempletTools.REMARK,
					"想快速掌握答题技巧吗？想获取最权威的学习资料吗？想了解重难点题型的解答过程吗？\n欢迎加入本书备考提升圈。作为出版社官方的学习交流圈"
							+ "，本书的作者和编辑，将为每一位读者提供最具时效性的、权威的一手学习资源。包括但不限于：\n1.本书的配套答案，快速检测答题准确率；\n2.本学期教学辅导"
							+ "资料,让读者掌握第一手备考资源，冲向高分；\n3.重难点题型解答，快速掌握重难点解题技巧；\n4.拔高小练习，巩固基础知识的同时提升应试能力；\n5.名师授课"
							+ "教学视频,打开读者的解题思路，从而掌握一道题，解决一类题。\n各项资源服务分类明确，且针对性强。并能让各位读者们与数万尖子生交流提升方法，获取备考"
							+ "经验、心得。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/fd39dee6ee2c6a7a137f4fb9f59bf505.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "绝大多数人都会做错的10道题");
			resultMap.put(TempletTools.REMARK, "绝大多数人都会做错的10道题");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/2b00d98a07570c9d1829fc573dde0c46.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		} else if (AppTypeEnum.EF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "为你定制的学习指导意见，快点击领取");
			resultMap.put(TempletTools.REMARK, "为你定制的学习指导意见，快点击领取");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/837157dab28aab7d6b7e0b55f2ff6257.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8693c9b303c1431ceb0e15bf2e549574.jpg");
		}
	}
	
	/**
	 * 专题类教材教辅（高中）
	 * 
	 * @param resultMap
	 * @param fromCode
	 * @param typeCode
	 */
	private static void setSpecialHiger(Map<String, Object> resultMap, String fromCode, String typeCode) {
		if (AppTypeEnum.GROUP.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "加入名师辅导圈，获取一对一答疑（读者圈）");
			resultMap.put(TempletTools.REMARK,
					"想快速掌握答题技巧吗？想获取最权威的学习资料吗？想了解重难点题型的解答过程吗？欢迎加入本书备考提升圈。作为出版社官方的学习交流圈"
							+ "，本书的作者和编辑，将为每一位读者提供最具时效性的、权威的一手学习资源。包括但不限于：\n1.本书的配套答案，快速检测答题准确率；"
							+ "\n2.本学期教学辅导资料,让读者掌握第一手备考资源，冲向高分；\n3.重难点题型解答，快速掌握重难点解题技巧；\n4.拔高小练习，巩固基础知"
							+ "识的同时提升应试能力；\n5.名师授课教学视频,打开读者的解题思路，从而掌握一道题，解决一类题。\n各项资源服务分类明确，且针对性强。"
							+ "并能让各位读者们与数万尖子生交流提升方法，获取备考经验、心得。（注：以上服务将不定期持续更新）");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 3.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/a7f2031087eceb118956487239ad6084.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/fd39dee6ee2c6a7a137f4fb9f59bf505.jpg");
		} else if (ProductTypeEnum.PDF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "绝大多数人都会做错的10道题");
			resultMap.put(TempletTools.REMARK, "绝大多数人都会做错的10道题");
			resultMap.put(TempletTools.DEAL_PRICE, 0.00d);
			resultMap.put(TempletTools.RETAIL_PRICE, 1.00d);
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/2b00d98a07570c9d1829fc573dde0c46.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/598770e646853bd88b186a9a9c994b38.jpg");
		} else if (AppTypeEnum.EF.name().equals(typeCode)) {
			resultMap.put(TempletTools.NAME, "@你有一份专属学习指导待查收");
			resultMap.put(TempletTools.REMARK, "@你有一份专属学习指导待查收");
			resultMap.put(TempletTools.COVER_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/3510928021e55d6e0a668baeef6f8fbb.jpg");
			resultMap.put(TempletTools.SPREAD_IMG, "https://oss.5rs.me/oss/uploadfe/jpg/8693c9b303c1431ceb0e15bf2e549574.jpg");
		}
	}

}
