package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletBookClassifyDao;
import com.pcloud.book.applet.dto.AppletBookClassifyDTO;
import com.pcloud.book.applet.entity.AppletBookClassify;
import com.pcloud.book.applet.dto.AppletBookClassifyRelationDTO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletBookClassifyDaoImpl
 * @Author zhuyajie
 * @Description 小程序书刊分类
 * @Date 2020/5/15 16:23
 * @Version 1.0
 **/
@Component
public class AppletBookClassifyDaoImpl extends BaseDaoImpl<AppletBookClassify> implements AppletBookClassifyDao{

    @Override
    public AppletBookClassify queryById(Long id) {
        return getSessionTemplate().selectOne(getStatement("queryById"), id);
    }

    @Override
    public List<AppletBookClassifyDTO> queryAll(Boolean showState) {
        Map<String, Object> map = new HashMap<>();
        map.put("showState", showState);
        return getSessionTemplate().selectList(getStatement("queryAll"), map);
    }

    @Override
    public void addBookClassifyRelation(List<AppletBookClassifyRelationDTO> bookClassifyRelations) {
        getSessionTemplate().insert(getStatement("addBookClassifyRelation"), bookClassifyRelations);
    }

    @Override
    public List<Long> getRelationBookTempletByBookClassify(Long bookClassifyId) {
        return getSessionTemplate().selectList(getStatement("getRelationBookTempletByBookClassify"), bookClassifyId);
    }

    @Override
    public Long getAppletBookClassifyId(Long firstClassifyId) {
        return getSessionTemplate().selectOne(getStatement("getAppletBookClassifyId"), firstClassifyId);
    }

    @Override
    public Map<Long, AppletBookClassifyDTO> getBookClassifyByIds(List<Long> bookAdviserIds) {
        return getSessionTemplate().selectMap(getStatement("getBookClassifyByIds"),bookAdviserIds,"id");    }

    @Override
    public Map<Long, AppletBookClassifyDTO> getClassifyNames(List<Long> templetIds) {
        return getSessionTemplate().selectMap(getStatement("getClassifyNames"),templetIds,"templetId");
    }
}
