package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.ServeCollectBiz;
import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * (ServeCollect)表控制层
 *
 * @author makejava
 * @since 2020-09-10 10:44:31
 */
@RestController("serveCollectFacade")
@RequestMapping("serveCollect")
public class ServeCollectFacade {

    @Autowired
    private ServeCollectBiz serveCollectBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo, @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(serveCollectBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(serveCollectBiz.getList(wechatUserId, currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>();
    }

    @ApiOperation("收藏")
    @PostMapping("collect")
    public ResponseDto<?> collect(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        serveCollect.setWechatUserId(wechatUserId);
        return new ResponseDto<>(serveCollectBiz.insert(serveCollect));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo, @RequestBody ServeCollect serveCollect) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        serveCollectBiz.update(serveCollect);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@CookieValue("userInfo") String userInfo, @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        serveCollectBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("取消收藏")
    @PostMapping("cancelCollect")
    public ResponseDto<?> cancelCollect(@CookieValue("userInfo") String userInfo, @RequestBody List<Long> ids) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (ListUtils.isEmpty(ids)) {
            throw BookBizException.PARAM_DELETION;
        }
        serveCollectBiz.cancelCollect(ids);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("getAllCollect")
    public ResponseDto<?> getAllCollect(@CookieValue("userInfo") String userInfo) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        List<Long> ids = serveCollectBiz.getAllCollect(wechatUserId);
        return new ResponseDto<>(ListUtils.isEmpty(ids) ? new ArrayList<>() : ids);
    }

}