package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.dto.BookAuthCodeDTO;
import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.common.core.dao.BaseDao;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 19:31
 */
public interface BookAuthCodeDao extends BaseDao<BookAuthCode> {
    /**
     * 获取最大批次号
     */
    Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     * 更新使用次数
     */
    Integer updateUseCount(Long bookId, Long channelId, Long adviserId, String code, Integer codeUseCount, Integer authBookType);

    /**
     * 获取码数量
     */
    Boolean getIsHaveCode(Long bookId, Long channelId, Long adviserId, String code, Integer authBookType);

    /**
     * 批量删除正版授权码
     * @param ids
     */
    void batchDeleteCode(List<Long> ids);

    /**
     * 获取授权码列表
     * @param paramMap
     * @return
     */
    List<BookAuthCodeDTO> getBookAuthCodeList(Map<String, Object> paramMap);

    /**
     * 根据主键获取授权码
     * @param codeId
     * @return
     */
    BookAuthCodeDTO getBaseById(Long codeId);
}
