package com.pcloud.book.riddle.biz;

import com.pcloud.book.riddle.dto.CouponClickDTO;
import com.pcloud.book.riddle.dto.GroupRedisDTO;
import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.book.riddle.entity.RiddleClickRecord;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;

/**
 * @描述：猜谜过程
 * @作者：zhuyajie
 * @创建时间：18:20 2019/7/24
 * @版本：1.0
 */
public interface RiddleRecordBiz {

    /**
     * 猜谜过程
     * @param sendTextDTO
     */
    public void riddleProcess(SendTextDTO sendTextDTO);

    /**
     * 猜谜语详情列表
     * @param partyId
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBeanNew<GroupRiddleDTO> listPage(Long partyId, Integer currentPage, Integer numPerPage, String name);

    /**
     * 修改猜谜语开启状态
     * @param qrcodeId
     * @param status
     */
    void updateRiddleOpenStatus(Long qrcodeId, Boolean status);

    /**
     * 自动结束
     * @param wxGroupId
     * @param wxId
     * @param ip
     * @param wxUserId
     */
    public void autoEnd(String wxGroupId, String wxId, String ip, String wxUserId);

    /**
     * 根据类型查回复语
     * @param type
     * @return
     */
    public String getRandomReply(String type);

    /**
     * 发文本消息
     * @param wxId
     * @param wxGroupId
     * @param content
     * @param ip
     * @param wxUserId
     */
    public void sendWeixinTextMessage(String wxId, String wxGroupId, String content, String ip, String wxUserId);

    /**
     * 发送答错文案
     * @param groupRedisDTO
     */
    public void sendIncorrectMessage(GroupRedisDTO groupRedisDTO);

    /**
     * 发送优惠券链接
     * @param wxGroupId
     * @param wxId
     * @param ip
     */
    public void sendCouponLink(String wxId, String wxGroupId, String ip);

    /**
     * 礼券点击记录埋点
     * @param riddleClickRecord
     */
    void addClickTrack(RiddleClickRecord riddleClickRecord);

    /**
     * 优惠券剩余领取次数
     * @param wxGroupId
     * @param wechatUserId
     * @return
     */
    CouponClickDTO getGroupWishCount(String wxGroupId, Long wechatUserId);
}
