package com.pcloud.book.cultivate.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 小睿养成记录
 */
@Data
@ApiModel("小睿养成记录")
public class CultivateRecord extends BaseEntity {

    @ApiModelProperty("养成id")
    private Long cultivateId;

    @ApiModelProperty("用户id")
    private Long wechatUserId;

    @ApiModelProperty("动态类型（1鱼丸获取2点亮3熄灭4升级5使用能量值6使用技能7鱼丸兑换星星）")
    private Integer changeType;

    @ApiModelProperty("备注信息")
    private String remark;

    @ApiModelProperty("能量变化")
    private Integer energyChange;

    @ApiModelProperty("鱼丸变化")
    private Integer fishBallChange;

    @ApiModelProperty("鱼丸变化类型：1用户自己收，2熄灯之后系统自动收取")
    private Integer fishBallChangeType;

    @ApiModelProperty("星星变化")
    private Integer starChange;

    @ApiModelProperty("使用技能类型")
    private Integer skillType;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;
}
