package com.pcloud.book.personalstage.dto;

import com.pcloud.book.personalstage.entity.PersonalStage;
import com.pcloud.book.personalstage.entity.PersonalStageJumpEmail;
import com.pcloud.book.personalstage.entity.PersonalStageJumpKeyword;
import com.pcloud.book.personalstage.entity.PersonalStageJumpLinkup;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 定制化阶段跳转(PersonalStageJump)实体类
 *
 * @author makejava
 * @since 2020-02-20 14:06:05
 */
@Data
public class PersonalStageJumpDto implements Serializable {

    @ApiModelProperty("跳转id")
    private Long id;

    @ApiModelProperty("定制化阶段id")
    private Long personalStageId;

    @ApiModelProperty("跳转类型：1读者输入关键词触发，2小睿发送关键词触发，3转账触发")
    private Integer jumpType;

    @ApiModelProperty("跳转后阶段id")
    private Long afterPersonalStageId;

    @ApiModelProperty("是否开启邮件提醒")
    private Boolean openEmail;

    @ApiModelProperty("转账说明")
    private String transferMessage;

    @ApiModelProperty("转账金额")
    private Double transferMoney;

    @ApiModelProperty("定制化阶段名称")
    private String personalStageName;

    @ApiModelProperty("跳转关键词文案列表")
    private List<PersonalStageJumpKeyword> jumpKeywords;

    @ApiModelProperty("邮件列表")
    private List<PersonalStageJumpEmail> jumpEmails;

    @ApiModelProperty("衔接语")
    private List<PersonalStageJumpLinkup> jumpLinkups;
}