package com.pcloud.book.personalstage.facade;

import com.pcloud.book.personalstage.biz.PersonalStageBiz;
import com.pcloud.book.personalstage.biz.PersonalStageProgressMessageBiz;
import com.pcloud.book.personalstage.dto.LinkClickRecordDTO;
import com.pcloud.book.personalstage.dto.EndServiceJumpNextDTO;
import com.pcloud.book.personalstage.dto.PersonalStageProgressDTO;
import com.pcloud.book.personalstage.dto.PlanJumpNextDTO;
import com.pcloud.book.personalstage.entity.PersonalStage;
import com.pcloud.book.personalstage.entity.PersonalStageProgressMessage;
import com.pcloud.book.personalstage.enums.JumpTypeEnum;
import com.pcloud.book.personalstage.vo.request.AddScoreRequestVO;
import com.pcloud.book.personalstage.vo.request.CreateStageJumpRequestVO;
import com.pcloud.book.personalstage.vo.request.UpdateStageJumpRequestVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.page.PageParam;
import com.pcloud.book.personalstage.biz.PersonalStageJumpBiz;
import com.pcloud.common.utils.string.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Optional;

@Api("定制化阶段")
@RestController("personalStageFacade")
@RequestMapping("personalStage")
public class PersonalStageFacade {

    @Autowired
    private PersonalStageBiz personalStageBiz;
    @Autowired
    private PersonalStageJumpBiz personalStageJumpBiz;
    @Autowired
    private PersonalStageProgressMessageBiz personalStageProgressMessageBiz;

    @ApiOperation("新增定制化阶段")
    @PostMapping("/createPersonalStage")
    public ResponseDto<?> createPersonalStage(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("定制化阶段") PersonalStage personalStage
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(personalStageBiz.createPersonalStage(personalStage));
    }

    @ApiOperation("修改定制化阶段")
    @PostMapping("/updatePersonalStage")
    public ResponseDto<?> updatePersonalStage(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("定制化阶段") PersonalStage personalStage
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        personalStageBiz.updatePersonalStage(personalStage);
        return new ResponseDto<>();
    }

    @ApiOperation("删除定制化阶段")
    @GetMapping("/deletePersonalStage")
    public ResponseDto<?> deletePersonalStage(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") @ApiParam("定制化阶段id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        personalStageBiz.deletePersonalStage(id);
        return new ResponseDto<>();
    }

    @ApiOperation("获取定制化阶段")
    @GetMapping("/getPersonalStage")
    public ResponseDto<?> getPersonalStage(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("id") @ApiParam("定制化阶段id") Long id
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(personalStageBiz.getPersonalStage(id));
    }

    @ApiOperation("修改排序值")
    @PostMapping("/updateSeqNum")
    public ResponseDto<?> updateSeqNum(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("定制化阶段") PersonalStage personalStage
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        personalStageBiz.updateSeqNum(personalStage);
        return new ResponseDto<>();
    }


    @RequestMapping(value = "getPersonalStageList", method = RequestMethod.GET)
    @ApiOperation(value = "获取阶段列表", httpMethod = "GET")
    public ResponseDto<?> getPersonalStageList(@RequestHeader("token") String token, @RequestParam(value = "robotClassifyId", required = false) Long robotClassifyId,
                                               @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                               @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws PermissionException, BizException {
        SessionUtil.getToken4Redis(token);
        if (null == robotClassifyId) {
            throw BookBizException.PARAM_DELETION;
        }
        if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
            throw BookBizException.PAGE_PARAM_DELETION;
        }
        return new ResponseDto<>(personalStageBiz.getPersonalStageList(robotClassifyId, new PageParam(currentPage, numPerPage)));
    }

    @RequestMapping(value = "getPersonalStageListNoPage", method = RequestMethod.GET)
    @ApiOperation(value = "获取阶段列表", httpMethod = "GET")
    public ResponseDto<?> getPersonalStageListNoPage(@RequestHeader("token") String token, @RequestParam(value = "robotClassifyId", required = false) Long robotClassifyId)
            throws PermissionException, BizException {
        SessionUtil.getToken4Redis(token);
        if (null == robotClassifyId) {
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(personalStageBiz.getPersonalStageListNoPage(robotClassifyId));
    }

    @ApiOperation("获取跳转列表")
    @GetMapping("getJumpList")
    public ResponseDto<?> getJumpList(@RequestHeader("token") String token, @RequestParam Long personalStageId, @RequestParam("currentPage") Integer currentPage, @RequestParam("numPerPage") Integer numPerPage) throws PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (null == personalStageId) {
            throw BookBizException.PARAM_DELETION;
        }
        if (currentPage == null || numPerPage == null || currentPage < 0 || numPerPage < 0) {
            throw BookBizException.PAGE_PARAM_DELETION;
        }
        return new ResponseDto<>(personalStageJumpBiz.getJumpList(personalStageId, currentPage, numPerPage));
    }

    @ApiOperation("获取跳转详情")
    @GetMapping("getJump")
    public ResponseDto<?> getJump(@RequestHeader("token") String token, @RequestParam Long jumpId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (null == jumpId) {
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(personalStageJumpBiz.getJump(jumpId));

    }

    @ApiOperation("删除跳转")
    @GetMapping("deleteJump")
    public ResponseDto<?> deleteJump(@RequestHeader("token") String token, @RequestParam Long jumpId) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (null == jumpId) {
            throw BookBizException.PARAM_DELETION;
        }
        personalStageJumpBiz.deleteJump(jumpId);
        return new ResponseDto<>();

    }

    @ApiOperation("打开关闭Email通知")
    @GetMapping("updateEmailStatus")
    public ResponseDto<?> updateEmailStatus(@RequestHeader("token") String token, @RequestParam Long jumpId,@RequestParam Integer openEmail) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        if (null == jumpId) {
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(personalStageJumpBiz.updateEmailStatus(jumpId, openEmail));

    }

    @ApiOperation("新建跳转")
    @PostMapping("createPersonalStageJump")
    public ResponseDto<?> createPersonalStageJump(@RequestHeader("token") String token, @Validated @RequestBody CreateStageJumpRequestVO vo) throws PermissionException, BizException{
        Optional.ofNullable(vo).orElseThrow(() -> new BookBizException(BookBizException.ERROR, "参数为空"));
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        personalStageJumpBiz.createPersonalStageJump(vo);
        return new ResponseDto<>();
    }

    @ApiOperation("修改跳转")
    @PostMapping("updatePersonalStageJump")
    public ResponseDto<?> updatePersonalStageJump(@RequestHeader("token") String token, @Validated @RequestBody UpdateStageJumpRequestVO vo) throws PermissionException, BizException{
        Optional.ofNullable(vo).orElseThrow(() -> new BookBizException(BookBizException.ERROR, "参数为空"));
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        personalStageJumpBiz.updatePersonalStageJump(vo);
        return new ResponseDto<>();
    }

    @ApiOperation("获取进度")
    @GetMapping("getPersonalProgress")
    public ResponseDto<?> getPersonalProgress(@RequestParam("wxUserId") String wxUserId,
                                              @RequestParam("personalStageUserId") Long personalStageUserId,
                                              @RequestParam("progressId") Long progressId) throws PermissionException, BizException{
        PersonalStageProgressDTO personalStageProgressDTO =  personalStageBiz.getPersonalProgress(wxUserId, personalStageUserId,progressId);
        return new ResponseDto<>(personalStageProgressDTO);
    }

    @ApiOperation("查询所有的进度消息")
    @GetMapping("getProgressMessageList")
    public ResponseDto<?> getProgressMessageList(@RequestParam("progressId") Integer progressId)
            throws BizException, PermissionException {
        return new ResponseDto<>(personalStageProgressMessageBiz.getProgressMessageList(progressId));
    }

    @ApiOperation("保存进度消息")
    @PostMapping("saveProgressMessage")
    public ResponseDto<?> saveProgressMessage(@RequestBody List<PersonalStageProgressMessage> personalStageProgressMessage)
            throws BizException, PermissionException {
        return new ResponseDto<>(personalStageProgressMessageBiz.save(personalStageProgressMessage));
    }

    @ApiOperation("增加进度值")
    @PostMapping("addScore")
    public ResponseDto<?> addScore(@Validated @RequestBody AddScoreRequestVO vo) throws BizException, PermissionException{
        Optional.ofNullable(vo).orElseThrow(() -> new BookBizException(BookBizException.ERROR, "参数为空"));
        personalStageBiz.updateScore(vo);
        return new ResponseDto<>();
    }

    @ApiOperation("是否第一次访问进度单")
    @GetMapping("isFirstVisit")
    public ResponseDto<?> isFirstVisit(@RequestParam("personalStageUserId") Long personalStageUserId){
        Optional.ofNullable(personalStageUserId).orElseThrow(() -> new BookBizException(BookBizException.ERROR, "参数为空"));
        return new ResponseDto<>(personalStageBiz.isFirstVisit(personalStageUserId));
    }

    @ApiOperation("获取单个用户当前定制化阶段")
    @GetMapping("/getCurrentPersonalStage")
    public ResponseDto<?> getCurrentPersonalStage(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("wxId") @ApiParam("用户id") String wxId,
            @RequestParam("robotId") @ApiParam("机器人id") String robotId
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(personalStageBiz.getCurrentPersonalStage(wxId, robotId));
    }

    @ApiOperation("获取阶段设置期间用户输入的需求单信息")
    @GetMapping("getUserInputPaperInfo")
    public ResponseDto<?> getUserInputPaperInfo(
            @RequestParam("robotWxId") @ApiParam("小号id") String robotWxId,
            @RequestParam("userWxId") @ApiParam("用户id") String userWxId){
        if (StringUtil.isEmpty(robotWxId) || StringUtil.isEmpty(userWxId)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少用户或小号id");
        }
        Map<String,Object> map = personalStageJumpBiz.getUserInputPaperInfo(robotWxId, userWxId);
        return new ResponseDto<>(map);
    }

    @ApiOperation("保存进度单/需求单链接点击记录")
    @PostMapping("addLinkClickRecord")
    public ResponseDto<?> addLinkClickRecord(@RequestBody @ApiParam("链接点击记录") LinkClickRecordDTO linkClickRecordDTO){
        if (null == linkClickRecordDTO || StringUtil.isEmpty(linkClickRecordDTO.getRobotId()) || StringUtil.isEmpty(linkClickRecordDTO.getWxId())
        ||null==linkClickRecordDTO.getLinkType()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数缺失");
        }
        if (linkClickRecordDTO.getLinkType()==2&&null==linkClickRecordDTO.getPaperId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺失需求单id");
        }
        personalStageJumpBiz.addLinkClickRecord(linkClickRecordDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("获取定制化阶段是否含有人工客服结束跳转")
    @GetMapping("/getHasEndServiceJump")
    public ResponseDto<?> getEndServiceJump(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("personalStageId") @ApiParam("阶段id") Long personalStageId
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(personalStageJumpBiz.getHasEndServiceJump(personalStageId));
    }

    @ApiOperation("人工客服阶段跳转")
    @PostMapping("/endServiceJumpNext")
    public ResponseDto<?> endServiceJumpNext(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("人工客服阶段跳转") EndServiceJumpNextDTO endServiceJumpNextDTO
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        personalStageJumpBiz.endServiceJumpNext(endServiceJumpNextDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("方案阶段跳转")
    @PostMapping("/planJumpNext")
    public ResponseDto<?> planJumpNext(
            @RequestBody @ApiParam("方案阶段跳转") PlanJumpNextDTO planJumpNextDTO
    ) throws BizException, PermissionException {
        personalStageJumpBiz.planJumpNext(planJumpNextDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("获取进度单列表")
    @GetMapping("getProgressList")
    public ResponseDto<?> getProgressList(@RequestHeader("token") @ApiParam("token信息") String token) throws PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
       List<PersonalStageProgressDTO> personalStageProgressDTOS = personalStageProgressMessageBiz.getProgressList();
        return new ResponseDto<>(personalStageProgressDTOS);
    }

    @ApiOperation("获取所有替换码")
    @GetMapping("getAllReplaceCode")
    public ResponseDto<?> getAllReplaceCode(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(personalStageBiz.getAllReplaceCode());
    }

    @ApiOperation("获取用户替换map")
    @GetMapping("getUserReplaceMap")
    public ResponseDto<?> getUserReplaceMap(@RequestParam("wxId") @ApiParam("用户id") String wxId, @RequestParam("robotId") @ApiParam("机器人id") String robotId){
        return new ResponseDto<>(personalStageBiz.getUserReplaceMap(wxId,robotId));
    }

}
