package com.pcloud.book.personalstage.vo.request;

import com.pcloud.book.personalstage.entity.PersonalStageJump;
import com.pcloud.common.utils.BeanUtils;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class UpdateStageJumpRequestVO extends BaseStageJumpRequestVO {
    @NotNull(message = "阶段跳转id不能为空")
    private Long personalStageJumpId;

    public static PersonalStageJump valueToJumpEntity(UpdateStageJumpRequestVO vo){
        PersonalStageJump personalStageJump = new PersonalStageJump();
        BeanUtils.copyProperties(vo, personalStageJump);
        personalStageJump.setCreateTime(new Date());
        personalStageJump.setId(vo.getPersonalStageJumpId());
        return personalStageJump;
    }
}
