package com.pcloud.book.clock.biz;

import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.dto.BookClockKeywordDTO;
import com.pcloud.book.clock.dto.BookGroupClockKeywordDTO;
import com.pcloud.book.clock.eneity.BookClockKeywordCheckParam;
import com.pcloud.book.clock.eneity.CancelSelectedParam;
import com.pcloud.common.page.PageBean;

/**
 * @Author: hzk
 * @Date: 2019/5/28 14:50
 * @Version 1.0
 */
public interface BookClockKeywordBiz {

    /**
     * 获取该关键词已关联的书及分类
     * @param bookClockKeywordCheckParam
     * @return
     */
    BookClockKeywordDTO getKeywordBookClockList(BookClockKeywordCheckParam bookClockKeywordCheckParam);

    /**
     * 发送关键词信息
     * @param bookClockInfoDTO
     * @param userWxId
     * @return
     */
    Boolean sendKeywordMessage(BookClockInfoDTO bookClockInfoDTO, String userWxId, String wechatGroupId, String wxId);

    /**
     * 获取微信群某一动作动作关键词
     * @param bookClockInfoId
     * @param operation
     * @return
     */
    BookGroupClockKeywordDTO getBookClockKeyword4Clock(Long bookClockInfoId,String operation);

    /**
     * 获取该关键词已关联的书及分类
     * @param bookClockKeywordCheckParam
     * @return
     */
    PageBean getKeywordBookClockList4HasSelected(BookClockKeywordCheckParam bookClockKeywordCheckParam);

    /**
     * 取消关联
     * @param cancelSelectedParam
     */
    void cancelSelected(CancelSelectedParam cancelSelectedParam);

}
