package com.pcloud.book.consumer.trade;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.tradecenter.dto.GroupMoneyDto;
import com.pcloud.facade.tradecenter.dto.QrGroupBuyDetailDto;
import com.pcloud.facade.tradecenter.dto.SpeWechatGroupDto;
import com.pcloud.facade.tradecenter.dto.WechatGroupDto;
import com.pcloud.facade.tradecenter.service.OrderFormService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author:lili
 * @Desr:交易调用
 * @Date:2019/5/7 17:22
 */
@Component("tradeConsr")
public class TradeConsr {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeConsr.class);
    @Autowired
    private OrderFormService orderFormService;

    public Map<Long, QrGroupBuyDetailDto> getQrGroupSaleDetail(List<Long> qrcodeIds) throws BizException {
        if (ListUtils.isEmpty(qrcodeIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(orderFormService.getQrGroupSaleDetail(qrcodeIds)
                    , Long.class, QrGroupBuyDetailDto.class);
        } catch (Exception e) {
            LOGGER.error("获取购买次数.[getQrGroupSaleDetail]:" + e.getMessage(), e);
        }
        return null;
    }

    /**
     * 获取交易额
     * @param wechatGroupDto
     * @return
     * @throws BizException
     */
    public Map<Long, GroupMoneyDto> getQrGroupSaleMoney(WechatGroupDto wechatGroupDto) throws BizException {
        Map<Long, GroupMoneyDto> map = new HashMap<>();
        if (wechatGroupDto == null) {
            return map;
        }
        try {
            ResponseEntity<ResponseDto<Map<Long, GroupMoneyDto>>> responseEntityP = orderFormService.getQrGroupSaleMoney(wechatGroupDto);
            map = ResponseHandleUtil.parseMap(responseEntityP, Long.class, GroupMoneyDto.class);
        } catch (Exception e) {
            LOGGER.error("获取交易额.[getQrGroupSaleMoney]:" + e.getMessage(), e);
        }
        if (map == null) {
            map = new HashMap<>();
        }
        return map;
    }

    /**
     * 获取购买人数量
     */
    public Map<Long, GroupMoneyDto> getSpeQrGroupSaleMoney(SpeWechatGroupDto speWechatGroupDto) throws BizException{
        Map<Long, GroupMoneyDto> map = new HashMap<>();
        if (speWechatGroupDto == null) {
            return map;
        }
        try {
            ResponseEntity<ResponseDto<Map<Long, GroupMoneyDto>>> responseEntityP = orderFormService.getSpeQrGroupSaleMoney(speWechatGroupDto);
            map = ResponseHandleUtil.parseMap(responseEntityP, Long.class, GroupMoneyDto.class);
        } catch (Exception e) {
            LOGGER.error("获取交易额.[获取购买人数量]:" + e.getMessage(), e);
        }
        if (map == null) {
            map = new HashMap<>();
        }
        return map;
    }
}
