package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@NoArgsConstructor
public class ProjectOrderSheetDTO {

    private Long id;

    private Long projectId;

    private Long orderSheetId;

    private String projectNumber;

    @ApiModelProperty("erp编号")
    private String erpNumber;

    @ApiModelProperty("出版物名称")
    private String bookName;

    @ApiModelProperty("关联RAYS书刊ID")
    private Integer raysBookId;

    @ApiModelProperty("RAYS编辑ID")
    private Integer raysAdviserId;

    @ApiModelProperty("关联RAYS渠道ID")
    private Integer raysChannelId;

    @ApiModelProperty("ISBN")
    private String bookIsbn;

    @ApiModelProperty("序号")
    private String seqNumber;

}
