package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.dto.RaysSceneCatalogDto;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 图书资源
 *
 * @version 1.0
 * @author:lili
 * @date 创建时间：2017年3月21日 上午11:34:18
 * @return
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookResourceServiceCloud", path = "book/v1.0/bookResourceService")
@Api(description = "图书资源内部服务")
public interface BookResourceService {

    /**
     * 获取图书关联资源
     *
     * @param bookId
     * @param channelId
     * @return
     */
    @ApiOperation(value = "获取图书关联资源", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "isbn", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/listBookResource", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<List<BookResourceDto>>> listBookResource(
            @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "adviserId", required = false) Long adviserId);

    @ApiOperation(value = "获取资源关联的图书", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "resourceId", value = "资源标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/listByResourceId", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<List<Long>>> listByResourceId(@RequestParam("resourceId") Long resourceId);

    @ApiOperation(value = "获取资源关联的图书", httpMethod = "GET")
    @RequestMapping(value = "/getSceneIdsByResourceId", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<List<Long>>> getSceneIdsByResourceId(@RequestParam("resourceId") Long resourceId);

    @ApiOperation(value = "获取符合开启资源目录的RAYS码ID列表")
    @PostMapping(value = "/listRaysSceneCatalogDto")
    ResponseEntity<ResponseDto<List<RaysSceneCatalogDto>>> listRaysSceneCatalogDto(@RequestBody List<Long> sceneIds);

}
