package com.pcloud.book.cultivate.enums;

public enum NotifyMessageType {
    //消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息

    SYSTEM(1,"系统消息"),
    NOTICE(2, "通知消息"),
    REMEMBER(3,"提醒消息"),
    ACTIVITY(4,"活动消息"),
    MORE(5,"更多消息");

    public Integer code;

    public String desc;

    NotifyMessageType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static NotifyMessageType geTypeByCode(Integer code) {
        if (null == code) {
            return null;
        }
        for (NotifyMessageType result : NotifyMessageType.values()) {
            if (result.code.equals(code)) {
                return result;
            }
        }
        return null;
    }
}
