package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.entity.AppletBookIgnor;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * (AppletBookIgnor)表服务接口
 *
 * @author makejava
 * @since 2021-05-06 13:49:59
 */
public interface AppletBookIgnorBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletBookIgnor getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletBookIgnor 实例对象
     * @return 主键
     */
    Long insert(AppletBookIgnor appletBookIgnor);

    /**
     * 修改数据
     *
     * @param appletBookIgnor 实例对象
     */
    void update(AppletBookIgnor appletBookIgnor);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 通过主键软删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void softDeleteById(Long id);

    /**
     * 获取所有书籍
     * @return
     */
    List<Long> getAllIgnorBookIds();
}