package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletRecordServeDao;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.entity.AppletRecordServe;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * (AppletRecordServe)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-09 16:04:32
 */
@Repository("appletRecordServeDaoImpl")
public class AppletRecordServeDaoImpl extends BaseDaoImpl<AppletRecordServe> implements AppletRecordServeDao {

    @Override
    public AppletRecordServe getByTypeAndServeId(Long wechatUserId, Integer recordType, Long fromId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("recordType", recordType);
        paramMap.put("fromId", fromId);
        return getSessionTemplate().selectOne(getStatement("getByTypeAndServeId"), paramMap);
    }

    @Override
    public Map<Long, AppletUserBookcaseDTO> getBookMap(List<AppletRecordDTO> appletRecordDTOS4Book) {
        return getSessionTemplate().selectMap(getStatement("getBookMap"), appletRecordDTOS4Book, "id");
    }

    @Override
    public List<AppletRecordDTO> getAppletRecordCatalogue(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("getAppletRecordCatalogue"), paramMap);
    }

    @Override
    public void batchUpdate(List<AppletRecordDTO> recordList) {
        getSessionTemplate().update(getStatement("batchUpdate"), recordList);
    }

    @Override
    public List<AppletRecordServe> getUserRecordListByType(Long wechatUserId, Integer recordType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("recordType", recordType);
        return getSessionTemplate().selectList(getStatement("getUserRecordListByType"), paramMap);
    }
}