package com.pcloud.book.applet.scheduleds;

import com.pcloud.book.applet.biz.AppletRecordStatisBiz;
import com.pcloud.book.skill.remind.RedisTool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component("appletRecordStatisSchedule")
public class AppletRecordStatisSchedule {

    @Autowired
    private AppletRecordStatisBiz appletRecordStatisBiz;

    @Scheduled(cron = "0 0 1 ? * MON")
    public void weekDataStatis() {
        String key = "BOOK_APPLET_RECORD_WEEK_STATIS_SCHEDULE";
        if (!RedisTool.lock(key)){
            return;
        }
        new Thread(() -> {
            appletRecordStatisBiz.addWeekAppletRecordStatis(null);
        }).start();
    }


}
