package com.pcloud.book.applet.service.impl;

import com.pcloud.book.applet.biz.AnswerSubscribeBiz;
import com.pcloud.book.applet.biz.AppletBannerBiz;
import com.pcloud.book.applet.biz.AppletBooklistBiz;
import com.pcloud.book.applet.biz.AppletBookClassifyBiz;
import com.pcloud.book.applet.biz.AppletNewsBiz;
import com.pcloud.book.applet.biz.AppletRecordBiz;
import com.pcloud.book.applet.biz.AppletRecordStatisBiz;
import com.pcloud.book.applet.biz.AppletRecordAggrStatisBiz;
import com.pcloud.book.applet.biz.AppletThirdResourcesStaticBiz;
import com.pcloud.book.applet.biz.AppletUserBookcaseBiz;
import com.pcloud.book.applet.biz.ReadBookRecordBiz;
import com.pcloud.book.applet.biz.ServeCollectBiz;
import com.pcloud.book.applet.dto.AnswerSubscribeUserDTO;
import com.pcloud.book.applet.dto.AppletAppOrProductDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletNewsVO;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.AppletThirdResourcesDTO;
import com.pcloud.book.applet.dto.BaseTempletClassifyDTO;
import com.pcloud.book.applet.dto.PcloudGroupActivityDTO;
import com.pcloud.book.applet.dto.ServeCollectDTO;
import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.book.applet.service.AppletService;
import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.book.rightsSetting.biz.RightsSettingBiz;
import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.ApiParam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.service.impl.AppletServiceImpl
 * @Author zhuyajie
 * @Description 小程序内部服务
 * @Date 2020/4/26 20:04
 * @Version 1.0
 **/
@RestController("appletService")
@RequestMapping("appletService")
public class AppletServiceImpl implements AppletService {

    @Autowired
    private AppletNewsBiz appletNewsBiz;

    @Autowired
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;
    @Autowired
    private AppletBooklistBiz appletBooklistBiz;
    @Autowired
    private AppletBookClassifyBiz appletBookClassifyBiz;
    @Autowired
    private AnswerSubscribeBiz answerSubscribeBiz;
    @Autowired
    private AppletThirdResourcesStaticBiz appletThirdResourcesStaticBiz;
    @Autowired
    private ServeCollectBiz serveCollectBiz;
    @Autowired
    private RightsSettingBiz rightsSettingBiz;
    @Autowired
    private AppletRecordStatisBiz appletRecordStatisBiz;
    @Autowired
    private AppletRecordBiz appletRecordBiz;
    @Autowired
    private AppletRecordAggrStatisBiz appletRecordAggrStatisBiz;
    @Autowired
    private AppletBannerBiz appletBannerBiz;
    @Autowired
    private ReadBookRecordBiz readBookRecordBiz;
    @Autowired
    private AppletUserBookcaseBiz appletUserBookcaseBiz;
    @Autowired
    private ResourcePageBiz resourcePageBiz;


    @Override
    @GetMapping("getNewsById")
    public ResponseEntity<ResponseDto<AppletNewsVO>> getNewsById(Long newsId) {
        return ResponseHandleUtil.toResponse(appletNewsBiz.getNewsVOById(newsId));
    }

    @Override
    @GetMapping("getGroupActivityById")
    public ResponseEntity<ResponseDto<PcloudGroupActivityDTO>> getGroupActivityById(@RequestParam("id") Long id){
        PcloudGroupActivity pcloudGroupActivity = pcloudGroupActivityBiz.getById(id);
        PcloudGroupActivityDTO newData = new PcloudGroupActivityDTO();
        BeanUtils.copyProperties(pcloudGroupActivity,newData);
        return ResponseHandleUtil.toResponse(newData);
    }

    @Override
    @GetMapping("getOuterBookById")
    public ResponseEntity<ResponseDto<AppletOuterBookDTO>> getOuterBookById(@RequestParam("outerBookId") Long outerBookId){
        return ResponseHandleUtil.toResponse(appletBooklistBiz.getOuterBookById(outerBookId));
    }

    @Override
    @GetMapping("createBaseClassifysToAgent")
    public void createBaseClassifysToAgent(@RequestParam("agentId") @ApiParam Long agentId){
        appletBookClassifyBiz.createBaseClassifysToAgent(agentId);
    }

    @Override
    @GetMapping("checkAnswerUpdate")
    public void checkAnswerUpdate(){
        answerSubscribeBiz.checkAnswerUpdate();
    }

    @Override
    @GetMapping("sendAppletMsg4Answer")
    public void sendAppletMsg4Answer(){
        answerSubscribeBiz.sendAppletMsg4Answer();
    }

    @Override
    @GetMapping("getAppletThirdResourceStatic")
    public void getAppletThirdResourceStatic(@RequestParam(value = "isAll", required = false) @ApiParam Integer isAll) {
        appletThirdResourcesStaticBiz.getAppletThirdResourceStatic(isAll);
    }

    @Override
    @PostMapping("getList4Collect")
    public ResponseEntity<ResponseDto<List<ServeCollectDTO>>> getList4Collect(@RequestBody List<ServeCollectDTO> serveCollects) {
        return ResponseHandleUtil.toResponse(serveCollectBiz.getList4Collect(serveCollects));
    }

    @Override
    @GetMapping("getPopupCount")
    public ResponseEntity<ResponseDto<Integer>> getPopupCount(@RequestParam("wechatUserId") Long wechatUserId,
                                                       @RequestParam("bookId") Long bookId,
                                                       @RequestParam("popupType") Integer popupType){
        return ResponseHandleUtil.toResponse(rightsSettingBiz.getPopupCount(wechatUserId, bookId, popupType));
    }

    @Override
    @ApiOperation("删除指定周的统计数据")
    @GetMapping("deleteWeekAppletRecordStatis")
    public void deleteWeekAppletRecordStatis(@RequestParam("mondayDate")String mondayDate) {
        appletRecordStatisBiz.deleteWeekAppletRecordStatis(mondayDate);
    }

    @Override
    @ApiOperation("统计指定周的数据")
    @GetMapping("addWeekAppletRecordStatis")
    public void addWeekAppletRecordStatis(@RequestParam(value = "mondayDate",required = false)String mondayDate) {
        appletRecordStatisBiz.addWeekAppletRecordStatis(mondayDate);
    }

    @Override
    @PostMapping("getNewsByIds")
    public ResponseEntity<ResponseDto<Map<Long, AppletNewsDTO>>> getNewsByIds(@RequestBody List<Long> newsIds) {
        return ResponseHandleUtil.toResponse(appletNewsBiz.getByIds(newsIds));
    }

    @Override
    @PostMapping("getOuterBooklistByIds")
    public ResponseEntity<ResponseDto<Map<Long, AppletOuterBooklistDTO>>> getOuterBooklistByIds(@RequestBody List<Long> bookRecommendIds) {
        return ResponseHandleUtil.toResponse(appletBooklistBiz.getByIds(bookRecommendIds));
    }

    @Override
    @GetMapping("getAllCollectServe")
    public ResponseEntity<ResponseDto<List<ServeCollectDTO>>> getAllCollectServe(@RequestParam("wechatUserId") Long wechatUserId) {
        List<ServeCollect> list4RightsSettingByWechatUserId = serveCollectBiz.getList4RightsSettingByWechatUserId(wechatUserId);
        List<ServeCollectDTO> serveCollectDTOS = new ArrayList<>();
        if (!ListUtils.isEmpty(list4RightsSettingByWechatUserId)) {
            com.pcloud.common.utils.BeanUtils.copyListProperties(list4RightsSettingByWechatUserId, serveCollectDTOS, ServeCollectDTO.class);
        }
        return ResponseHandleUtil.toResponse(serveCollectDTOS);
    }

    @Override
    @PostMapping("getAppOrProductBrowseCount")
    public ResponseEntity<ResponseDto<Map<Long, AppletAppOrProductDTO>>> getAppOrProductBrowseCount(@RequestParam("recordType") Integer recordType,
                                                                                                    @RequestBody List<Long> serveIds) {
        Map<Long, AppletAppOrProductDTO> appletAppOrProductDTOMap = appletRecordBiz.getAppOrProductBrowseCount(recordType, serveIds);
        return ResponseHandleUtil.toResponse(appletAppOrProductDTOMap);
    }

    @Override
    @GetMapping("fixAppletRecordDataSync4CH")
    public void fixAppletRecordDataSync4CH(@RequestParam(value = "createDate", required = false) String createDate){
        appletRecordAggrStatisBiz.fixAppletRecordDataSync4CH(createDate);
    }

    @Override
    @GetMapping("updateAggrStatisCache")
    public void updateAggrStatisCache(){
        appletRecordAggrStatisBiz.updateAggrStatisCache();
        appletRecordAggrStatisBiz.updateH5Resource();
        resourcePageBiz.insertCourseStatistic();
    }

    @Override
    @GetMapping("syncDataAndUpdateCache")
    public void syncDataAndUpdateCache(@RequestParam(value = "createDate", required = false) String createDate){
        appletRecordAggrStatisBiz.syncDataAndUpdateCache(createDate);
    }

    @Override
    @GetMapping("handleAppletRecordTypeCode")
    public ResponseEntity<ResponseDto<Object>> handleAppletRecordTypeCode(@RequestParam(value = "lastAppletRecordId", required = false) Long lastAppletRecordId){
        return ResponseHandleUtil.toResponse(appletRecordBiz.handleAppletRecordTypeCode(lastAppletRecordId));
    }

    @Override
    @GetMapping("stopHandleAppletRecordTypeCode")
    public void stopHandleAppletRecordTypeCode(){
        appletRecordBiz.stopHandleAppletRecordTypeCode();
    }

    @Override
    @GetMapping("autoChageBannerState")
    public void autoChageBannerState(@RequestParam("id") Long id,
                                     @RequestParam("showState") Integer showState) {
        appletBannerBiz.autoChageBannerState(id, showState);

    }

    @Override
    @ParamLog("定时任务从redis中删掉超时的本书服务记录")
    @GetMapping("autoDeleteReadBook")
    public void autoDeleteReadBook() {
        readBookRecordBiz.autoDeleteReadBook();
    }

    @Override
    @GetMapping("getThirdResourceById")
    public ResponseEntity<ResponseDto<AppletThirdResourcesDTO>> getThirdResourceById(@RequestParam("thirdResourcesId") Long thirdResourcesId) {
        AppletThirdResourcesDTO appletThirdResourcesDTO = appletNewsBiz.getThirdResourceById(thirdResourcesId);
        return ResponseHandleUtil.toResponse(appletThirdResourcesDTO);
    }

    @Override
    @RequestMapping("getLastReadBookInfo")
    public ResponseEntity<ResponseDto<BaseTempletClassifyDTO>> getLastReadBookInfo(@RequestBody List<Long> wechatUserIds) {
        return ResponseHandleUtil.toResponse(appletUserBookcaseBiz.getLastReadBookInfo(wechatUserIds));
    }

    @RequestMapping("getSameClassifyUserIds")
    @Override
    public ResponseEntity<ResponseDto<List<Long>>> getSameClassifyUserIds(@RequestBody List<Long> wechatUserIds){
        return ResponseHandleUtil.toResponse(appletUserBookcaseBiz.getSameClassifyUserIds(wechatUserIds));
    }

    @Override
    @GetMapping("getUserSubscribeInfo")
    public ResponseEntity<ResponseDto<AnswerSubscribeUserDTO>> getUserSubscribeInfo(@RequestParam("wechatUserId") Long wechatUserId){
        return ResponseHandleUtil.toResponse(answerSubscribeBiz.getUserSubscribeInfo(wechatUserId));
    }
}
