package com.pcloud.book.book.biz.impl;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.appcenter.assist.dto.AssistTempletDTO;
import com.pcloud.appcenter.assist.service.AssistTempletService;
import com.pcloud.book.book.biz.BookCoverBiz;
import com.pcloud.book.book.dao.BookCoverDao;
import com.pcloud.book.book.dto.BookCoverDTO;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ParamChecker;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("bookCoverBiz")
public class BookCoverBizimpl implements BookCoverBiz {

    /**
     * 日志
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(BookCoverBizimpl.class);

    @Autowired
    private AssistTempletService assistTempletService;

    @Autowired
    private BookCoverDao bookCoverDao;

    /**
     * 查询封面
     */
    @Override
    public PageBeanNew<BookCoverDTO> getCoverByTempletId(Long templetId, Integer currentPage, Integer perpageNumber) {

        Map<String, Object> paramMap = new HashMap<>();

        paramMap.put("templetId", templetId);
        //对分页参数检验
        ParamChecker.checkPageParamIsAbsent(currentPage, perpageNumber, "分页参数错误");

        PageParam pageParam = new PageParam(currentPage, perpageNumber);

        PageBeanNew<BookCoverDTO> pageBeanNew = bookCoverDao.listPageNew(pageParam, paramMap, "selectByTempletId");
        if (CollUtil.isEmpty(pageBeanNew.getRecordList())) {
            return pageBeanNew;
        }
        List<Long> collect = pageBeanNew.getRecordList().stream().map(BookCoverDTO::getTempletId).distinct().collect(Collectors.toList());

        Map<Long, AssistTempletDTO> templetMap = new HashMap<>();

        try {
            templetMap = ResponseHandleUtil.parseMap(assistTempletService.mapByIds(collect), Long.class, AssistTempletDTO.class);
        } catch (Exception e) {
            LOGGER.error("【书籍-封面】获取分类名称,<ERROR>.[assistTempletService.mapByIds]" + e.getMessage(), e);
        }
        if (CollUtil.isEmpty(templetMap)) {
            return pageBeanNew;
        }
        Map<Long, AssistTempletDTO> finalTempletMap = templetMap;
        pageBeanNew.getRecordList().forEach(bookCoverDTO -> {
            AssistTempletDTO assistTempletDTO = finalTempletMap.get(bookCoverDTO.getTempletId());
            if (Objects.nonNull(assistTempletDTO)) {
                bookCoverDTO.setTempletName(assistTempletDTO.getTempletName());
            }
        });
        return pageBeanNew;
    }

    /**
     * 新增封面
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookCoverDTO addCover(Long templetId,String coverImg) {
        //查询之前有没有相同
        BookCoverDTO bookCoverDTO = bookCoverDao.selectByTempletIdAndCoverImg(templetId, coverImg);
        if (bookCoverDTO !=null) {
            LOGGER.info("该封面已存在" + bookCoverDTO.toString());
            return bookCoverDTO;
        }
        //插入
        BookCoverDTO insert = new BookCoverDTO();
        insert.setTempletId(templetId);
        insert.setCoverImg(coverImg);
        bookCoverDao.insert(insert);
        return insert;
    }

    /**
     *删除封面
     */
    @Override
    public void deleteCoverById(String coverId) {
        LOGGER.info("【分类封面】删除封面,[coverId]=" + coverId);
        if (coverId == null) {
            LOGGER.error("【分类封面】删除封面失败,[coverId]为空" );
            return ;
        }
        bookCoverDao.deleteById(coverId);
    }

    @Override
    public void updateCover(Long templetId, String coverImg,String coverId) {
        if (coverImg == null) {
            LOGGER.error("【分类封面】参数传入失败,[coverImg]=" + coverImg);
            return;
        }
        BookCoverDTO coverDTO = new BookCoverDTO();
        coverDTO.setTempletId(templetId);
        coverDTO.setCoverImg(coverImg);
        coverDTO.setCoverId(coverId);
        bookCoverDao.updateCover(coverDTO);
    }

//    @Override
//    public BookCoverDTO selectByTempletIdAndCoverImg(Long templetId, String coverImg) {
//        if (templetId == null||coverImg ==null){
//            LOGGER.info("【分类封面】查询封面失败,[templetId] =｛｝，[coverImg] =｛｝",templetId,coverImg);
//            return null;
//        }
//        BookCoverDTO bookCoverDTO = bookCoverDao.selectByTempletIdAndCoverImg(templetId, coverImg);
//        return  bookCoverDTO;
//    }
}
