package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.BookLabelDao;
import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/27 17:23
 **/
@Repository("bookLabelDao")
public class BookLabelDaoImpl extends BaseDaoImpl<BookLabel> implements BookLabelDao {


    @Override
    public List<BookLabel> getListByType(Integer type, Long auditState) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("type", type);
        paramMap.put("auditState", auditState);
        return super.getSqlSession().selectList(super.getStatement("getListByType"), paramMap);
    }

    @Override
    public List<BookLabel> getAll(Long partyId) {
        Map<String,Object> map = new HashMap<>();
        map.put("createUser", partyId);
        return super.getSqlSession().selectList(super.getStatement("getAll"), map);
    }

    @Override
    public Map<Long, BookLabel> getMapByIds(List<Long> list) {
        return super.getSqlSession().selectMap(super.getStatement("getMapByIds"), list,"id");
    }

    @Override
    public List<BookLabel> getByLabelIds(List<Long> list) {
        return super.getSqlSession().selectList(super.getStatement("getByLabelIds"), list);
    }

    @Override
    public Long getByNameType(String name, Integer type) {
        Map<String,Object> map = new HashMap<>();
        map.put("name", name);
        map.put("type", type);
        return getSessionTemplate().selectOne(getStatement("getByNameType"), map);
    }

    @Override
    public Integer getMaxSeqByType(Integer type) {
        return getSessionTemplate().selectOne(getStatement("getMaxSeqByType"), type);
    }
}
