package com.pcloud.book.copyright.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @author lily
 * @date 2018/12/4 19:21
 */
@ApiModel
@Data
public class BookExportRecord extends BaseEntity {

    private Long id;

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("运营标识")
    private Long channelId;

    @ApiModelProperty("编辑标识")
    private Long adviserId;

    @ApiModelProperty("批次号")
    private String batchNum;

    @ApiModelProperty("下载地址")
    private String downloadUrl;

    @ApiModelProperty("创建人")
    private Long createdUser;

    @ApiModelProperty("创建时间")
    private Date createdDate;

    @ApiModelProperty("最后修改人")
    private Long lastModifiedUser;

    @ApiModelProperty("最后修改时间")
    private Date lastModifiedDate;

    @ApiModelProperty("导出状态")
    private Integer exportStatus;

    @ApiModelProperty("生成码数量")
    private Integer codeCount;

    @ApiModelProperty("导出格式")
    private Integer isHaveBarCode;

}
