package com.pcloud.book.cultivate.entity;

import com.pcloud.book.applet.dto.AppletBannerDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.ServeItemInfoDTO;
import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import com.pcloud.readercenter.applet.entity.AppletQuestion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel("小睿站内信内容")
public class CultivateNotifyItem extends BaseEntity {

    @ApiModelProperty("消息id")
    private Long messageId;

    @ApiModelProperty("发送内容（1-文本，2-图片，3-音频, 4-链接,5 问题）")
    private Integer contentType;

    @ApiModelProperty("文字内容")
    private String content;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("音频资源id")
    private Long resourceId;

    @ApiModelProperty("文件名称")
    private String fileName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;

    @ApiModelProperty("音频时长")
    private BigDecimal duration;

    @ApiModelProperty("站内信发送选择活动类型时的资源")
    private AppletBannerDTO sendServe;

    @ApiModelProperty("跳转类型 1指定页面, 2web页面, 3资讯, 4应用作品")
    private Integer jumpType;

    @ApiModelProperty("跳转地址")
    private String jumpUrl;

    @ApiModelProperty("作品/应用/咨询的ID")
    private Long serveId;

    @ApiModelProperty("作品5/应用6/咨询的类型1")
    private Integer serveType;

    @ApiModelProperty("咨询具体信息")
    private AppletNewsDTO newsItem;

    @ApiModelProperty("咨询具体信息")
    private ServeItemInfoDTO appItem;

    @ApiModelProperty("小睿互助问题")
    private AppletQuestion appletQuestion;





}
