package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.AddBookGroupServeDTO;
import com.pcloud.book.group.entity.ResourcePage;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;


/**
 * 自有码H5页面(ResourcePage)表数据库访问层
 *
 * @author makejava
 * @since 2021-03-26 15:25:28
 */
public interface ResourcePageDao extends BaseDao<ResourcePage>{



    /**
     * 根据社群书查询
     * @author：zhuyajie
     * @date：2021/3/30 10:35
     *  * @param null
     */
    ResourcePage getByBookGroupId(Long bookGroupId);

    /**
     * 根据书刊查询
     * @author：zhuyajie
     * @date：2021/3/30 10:35
     *  * @param null
     */
    ResourcePage getByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 修改页面更新时间
     * @author：zhuyajie
     * @date：2021/4/2 15:21
     *  * @param null
     */
    void updatePageUpdateTime(Long resourcePageId);
    /**
     * 根据二维码id查询
     * @author：zhuyajie
     * @date：2021/4/13 9:18
     *  * @param null
     */
    ResourcePage getBySceneId(Long sceneId);

    /**
     * 根据公众号二维码id查资源页
     * @author：zhuyajie
     * @date：2021/4/26 9:29
     *  * @param null
     */
    ResourcePage getPageByOfficialScene(Long officialSceneId);

    /**
     * 查开启小睿的二维码
     * @author：zhuyajie
     * @date：2021/4/30 14:32
     *  * @param null
     */
    List<Long> getOpenRaysSceneIds(List<Long> sceneIds);

    /**
     * 批量更新sceneId
     * @author：zhuyajie
     * @date：2021/4/30 19:58
     *  * @param null
     */
    void batchUpdateSceneIdByBookGroup(List<AddBookGroupServeDTO> list);

    /**
     * 查栏目对应的资源页
     * @author：zhuyajie
     * @date：2021/5/6 17:41
     *  * @param null
     */
    ResourcePage getPageByColumnId(Long resourcePageColumnId);

    List<Long> getSceneIdsByResourceId(Long resourceId);

    /**
     * 更新书刊id
     * @author：zhuyajie
     * @date：2021/5/11 18:50
     *  * @param null
     */
    void updateBookBySceneIds(List<Long> sceneIds, Long bookId, Long channelId);
    /**
     *同一本书其他码下关闭小睿流程
     * @author：zhuyajie
     * @date：2021/5/12 9:59
     *  * @param null
     */
    void setOtherPageRaysClose(Long bookId, Long channelId, Long createUser, Long sceneId, Long bookGroupId);

    /**
     * 书刊是否开启小睿
     * @author：zhuyajie
     * @date：2021/5/25 11:03
     *  * @param null
     */
    Boolean isOpenRaysBook(Long bookId, Long channelId, Long adviserId);
}