package com.pcloud.book.group.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * wework_teacher
 *
 * @author
 */
@ApiModel("客服老师企业微信二维码信息")
@Data
public class WeworkTeacher implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    /**
     * 企业微信二维码
     */
    @ApiModelProperty("企业微信二维码")
    private String qrcode;

    /**
     * 真实姓名
     */
    @ApiModelProperty("真实姓名")
    private String realName;

    /**
     * 昵称
     */
    @ApiModelProperty("昵称")
    private String nickname;

    /**
     * 头像地址
     */
    @ApiModelProperty("头像地址")
    private String avatar;

    /**
     * 描述
     */
    @ApiModelProperty("描述")
    private String desc;

    /**
     * 图文素材标题名称
     */
    @ApiModelProperty("图文素材标题名称")
    private String title;

    /**
     * 客服类型：1：苏老师  2：张哥哥
     */
    @ApiModelProperty("客服类型：1：苏老师  2：张哥哥")
    private Integer teacherType;

    /**
     * 开关状态
     */
    @ApiModelProperty("开关状态")
    private Integer isOpen;

    /**
     * 图文素材地址
     */
    @ApiModelProperty("图文素材地址")
    private String materialUrl;

    /**
     * 图文素材媒体ID
     */
    @ApiModelProperty("图文素材媒体ID")
    private String mediaId;

    /**
     * 公众号ID
     */
    @ApiModelProperty("公众号ID")
    private Long accountId;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;
}