package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookGroupClassifyAnalysisVO {

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("群分类名称")
    private String classifyName;

    @ApiModelProperty("群分类介绍")
    private String desc;

    @ApiModelProperty("专业")
    private Long proLabelId;

    @ApiModelProperty("深度")
    private Long depLabelId;

    @ApiModelProperty("目的")
    private Long purLabelId;

    @ApiModelProperty("专业标签名称")
    private String proLabelName;

    @ApiModelProperty("深度标签名称")
    private String depLabelName;

    @ApiModelProperty("目的标签名称")
    private String purLabelName;

    @ApiModelProperty("目的标签名称")
    private Integer groupType;

    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("城市名称")
    private String cityName;

    @ApiModelProperty("点击量pv/uv")
    private String clickPVUV;

    @ApiModelProperty("浏览量pv/uv")
    private String browsePVUV;

    @ApiModelProperty("微信入群文章链接")
    private String wxArticleUrl;

    @ApiModelProperty("第一级类型标识")
    private Long firstClassify;
    @ApiModelProperty("第一级类型标识名称")
    private String firstClassifyName;

    @ApiModelProperty("第二级类型标识")
    private Long secondClassify;

    @ApiModelProperty("第二级类型标识名称")
    private String secondClassifyName;

    @ApiModelProperty("年级标签id")
    private Long gradeLabelId;
    @ApiModelProperty("年级标签名称")
    private String gradeLabelName;

    @ApiModelProperty("科目标签id")
    private Long subjectLabelId;
    @ApiModelProperty("科目标签名称")
    private String subjectLabelName;

    @ApiModelProperty("第三级类型标识")
    private Long thirdClassify;

    @ApiModelProperty("第三级类型标识名称")
    private String thirdClassifyName;
}
