/**
 * 
 */
package com.pcloud.book.personalstage.utils;

import com.pcloud.common.utils.cache.redis.JedisClusterUtils;

public class CacheUtils {

	/**
	 * 加锁
	 * @param key
	 * @return
	 */
	public static boolean lock(String key){
		//加锁，如果返回1为true，表示已经加锁，如果再来存储同一个key会返回0为false
		Boolean flag = JedisClusterUtils.setnx(key,"lock");
		//如果为true的话，设置一个过期时间，防止锁释放不掉
		if(flag){
			JedisClusterUtils.expire(key,10);
		}
		return flag;
	}

	/**
	 * 释放锁
	 */
	public static void unlock(String key){
		JedisClusterUtils.del(key);
	}

}
